/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.configuration.CoreAutoConfiguration;
import com.taotao.boot.monitor.Monitor;
import com.taotao.boot.monitor.collect.CollectorMetrics;
import com.taotao.boot.monitor.collect.HealthCheckProvider;
import com.taotao.boot.monitor.collect.HealthReportFilter;
import com.taotao.boot.monitor.configuration.MonitorAutoConfiguration;
import com.taotao.boot.monitor.configuration.WarnProviderAutoConfiguration;
import com.taotao.boot.monitor.endpoint.MonitorEndPoint;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import com.taotao.boot.monitor.properties.MonitorProperties;
import com.taotao.boot.monitor.strategy.WarnStrategy;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CoreAutoConfiguration.class, WarnProviderAutoConfiguration.class, MonitorAutoConfiguration.class})
@EnableConfigurationProperties(value={MonitorProperties.class, CollectTaskProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.monitor", name={"enabled"}, havingValue="true")
public class HealthAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(HealthAutoConfiguration.class, (String)"taotao-boot-starter-monitor", (String[])new String[0]);
    }

    @Bean(destroyMethod="close")
    public HealthCheckProvider healthCheckProvider(WarnStrategy strategy, CollectTaskProperties collectTaskProperties, MonitorProperties monitorProperties, Monitor monitor) {
        return new HealthCheckProvider(collectTaskProperties, monitorProperties, strategy, monitor);
    }

    @Bean
    public MonitorEndPoint systemHealthEndPoint(HealthCheckProvider healthCheckProvider) {
        return new MonitorEndPoint(healthCheckProvider);
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public FilterRegistrationBean<HealthReportFilter> healthReportFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(-2147483646);
        filterRegistrationBean.setFilter((Filter)new HealthReportFilter());
        filterRegistrationBean.setName(HealthReportFilter.class.getName());
        filterRegistrationBean.addUrlPatterns(new String[]{"/health/report/*"});
        return filterRegistrationBean;
    }

    @Bean
    public CollectorMetrics collectorMetrics(@Autowired(required=false) HealthCheckProvider healthCheckProvider) {
        return new CollectorMetrics(healthCheckProvider);
    }
}

