/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.configuration;

import com.taotao.boot.common.support.thread.MDCThreadPoolExecutor;
import com.taotao.boot.common.support.thread.ThreadPoolFactory;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.configuration.CoreAutoConfiguration;
import com.taotao.boot.core.properties.AsyncProperties;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.Monitor;
import com.taotao.boot.monitor.properties.MonitorProperties;
import com.taotao.boot.monitor.properties.MonitorThreadPoolProperties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@AutoConfiguration(after={CoreAutoConfiguration.class})
@EnableConfigurationProperties(value={MonitorThreadPoolProperties.class, MonitorProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.monitor", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MonitorAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(MonitorAutoConfiguration.class, (String)"taotao-boot-starter-core", (String[])new String[0]);
    }

    @Bean(value={"monitorThreadPoolExecutor"})
    public ThreadPoolExecutor monitorThreadPoolExecutor(MonitorThreadPoolProperties monitorThreadPoolProperties) {
        String monitorThreadName = monitorThreadPoolProperties.getThreadNamePrefix();
        MDCThreadPoolExecutor monitorThreadPoolExecutor = new MDCThreadPoolExecutor(monitorThreadPoolProperties.getCorePoolSize(), monitorThreadPoolProperties.getMaximumPoolSize(), monitorThreadPoolProperties.getKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new ThreadPoolFactory(monitorThreadName, true));
        monitorThreadPoolExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return monitorThreadPoolExecutor;
    }

    @Bean
    public Monitor monitor(MonitorThreadPoolProperties monitorThreadPoolProperties, @Autowired @Qualifier(value="asyncThreadPoolTaskExecutor") ThreadPoolTaskExecutor asyncThreadPoolTaskExecutor, @Autowired @Qualifier(value="monitorThreadPoolExecutor") ThreadPoolExecutor monitorThreadPoolExecutor, AsyncProperties asyncProperties, Collector collector) {
        return new Monitor(collector, asyncProperties, monitorThreadPoolProperties, asyncThreadPoolTaskExecutor, monitorThreadPoolExecutor);
    }
}

