/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.ping.PingFilter;
import com.taotao.boot.monitor.properties.PingProperties;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={PingProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.monitor.ping", name={"enabled"}, havingValue="true")
public class PingProviderAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(PingProviderAutoConfiguration.class, (String)"taotao-boot-starter-monitor", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public FilterRegistrationBean<PingFilter> pingFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(Integer.MIN_VALUE);
        filterRegistrationBean.setFilter((Filter)new PingFilter());
        filterRegistrationBean.setName(PingFilter.class.getName());
        filterRegistrationBean.addUrlPatterns(new String[]{"/health/ping"});
        return filterRegistrationBean;
    }
}

