/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.export;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.taotao.boot.common.constant.CommonConstants;
import com.taotao.boot.common.utils.common.PropertyUtils;
import com.taotao.boot.monitor.export.AbstractExport;
import com.taotao.boot.monitor.model.Report;
import com.taotao.boot.monitor.properties.ExportProperties;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import net.logstash.logback.marker.MapEntriesAppendingMarker;
import org.dromara.hutool.core.date.DateUtil;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ElkExport
extends AbstractExport {
    private final ExportProperties exportProperties;
    private final LogstashTcpSocketAppender appender;

    public ElkExport(ExportProperties exportProperties, LogstashTcpSocketAppender appender) {
        this.exportProperties = exportProperties;
        this.appender = appender;
    }

    @Override
    public void start() {
        super.start();
        ILoggerFactory log = LoggerFactory.getILoggerFactory();
        if (log instanceof Context) {
            this.appender.setContext((Context)log);
            LogstashEncoder encoder = new LogstashEncoder();
            String appName = "Report-" + (String)PropertyUtils.getPropertyCache((String)CommonConstants.SPRING_APP_NAME_KEY, (Object)"");
            encoder.setCustomFields("{\"appname\":\"" + appName + "\",\"appindex\":\"Report\"}");
            encoder.setEncoding("UTF-8");
            this.appender.setEncoder((Encoder)encoder);
            this.appender.start();
        }
    }

    @Override
    public void run(Report report) {
        if (this.appender == null || !this.exportProperties.getElkEnabled()) {
            return;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        report.eachReport((field, reportItem) -> {
            if (reportItem != null && reportItem.getValue() instanceof Number) {
                map.put(field.replace(".", "_"), reportItem.getValue());
            }
            return reportItem;
        });
        LoggingEvent event = this.createLoggerEvent(map, "taotao boot report:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.appender.doAppend((Object)event);
    }

    private LoggingEvent createLoggerEvent(Map<String, Object> values, String message) {
        LoggingEvent loggingEvent = new LoggingEvent();
        loggingEvent.setTimeStamp(System.currentTimeMillis());
        loggingEvent.setLevel(Level.INFO);
        loggingEvent.setLoggerName("ReportLogger");
        loggingEvent.addMarker((Marker)new MapEntriesAppendingMarker(values));
        loggingEvent.setMessage(message);
        loggingEvent.setArgumentArray((Object[])new String[0]);
        loggingEvent.setThreadName(Thread.currentThread().getName());
        return loggingEvent;
    }

    @Override
    public void close() {
        super.close();
        if (this.appender != null) {
            this.appender.stop();
        }
    }
}

