/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.export;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.Monitor;
import com.taotao.boot.monitor.collect.HealthCheckProvider;
import com.taotao.boot.monitor.export.AbstractExport;
import com.taotao.boot.monitor.export.ElkExport;
import com.taotao.boot.monitor.model.Report;
import com.taotao.boot.monitor.properties.ExportProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.logstash.logback.appender.LogstashTcpSocketAppender;

public class ExportProvider {
    private boolean isClose = true;
    private final Monitor monitorThreadPool;
    private final ExportProperties exportProperties;
    private final HealthCheckProvider healthCheckProvider;
    protected List<AbstractExport> exports = new ArrayList<AbstractExport>();

    public ExportProvider(Monitor monitorThreadPool, ExportProperties exportProperties, HealthCheckProvider healthCheckProvider) {
        this.monitorThreadPool = monitorThreadPool;
        this.exportProperties = exportProperties;
        this.healthCheckProvider = healthCheckProvider;
    }

    public void registerCollectTask(AbstractExport export) {
        this.exports.add(export);
    }

    public void start() {
        LogstashTcpSocketAppender logstashTcpSocketAppender;
        this.isClose = false;
        if (this.exportProperties.getElkEnabled() && Objects.nonNull(logstashTcpSocketAppender = (LogstashTcpSocketAppender)ContextUtils.getBean(LogstashTcpSocketAppender.class, (boolean)false))) {
            this.registerCollectTask(new ElkExport(this.exportProperties, logstashTcpSocketAppender));
        }
        this.monitorThreadPool.monitorSubmit("\u7cfb\u7edf\u4efb\u52a1: ExportProvider \u91c7\u96c6\u4e0a\u4f20\u4efb\u52a1", () -> {
            while (!this.monitorThreadPool.monitorIsShutdown() && !this.isClose) {
                try {
                    this.run();
                }
                catch (Exception e) {
                    LogUtils.error((String)"taotao-boot-starter-monitor", (Object[])new Object[]{"run \u5faa\u73af\u4e0a\u4f20\u62a5\u8868\u51fa\u9519", e});
                }
                try {
                    Thread.sleep((long)this.exportProperties.getExportTimeSpan() * 1000L);
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        });
        for (AbstractExport e : this.exports) {
            try {
                e.start();
            }
            catch (Exception ex) {
                LogUtils.error((String)"taotao-boot-starter-monitor", (Object[])new Object[]{e.getClass().getName() + "\u542f\u52a8\u51fa\u9519", ex});
            }
        }
    }

    public void run() {
        if (this.healthCheckProvider != null) {
            Report report = this.healthCheckProvider.getReport(false);
            for (AbstractExport e : this.exports) {
                e.run(report);
            }
        }
    }

    public void close() {
        this.isClose = true;
        for (AbstractExport e : this.exports) {
            try {
                e.close();
            }
            catch (Exception ex) {
                LogUtils.error((Throwable)ex, (String)"taotao-boot-starter-monitor", (Object[])new Object[]{e.getClass().getName() + "\u5173\u95ed\u51fa\u9519"});
            }
        }
    }
}

