/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.model;

import com.taotao.boot.common.utils.common.JsonUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.number.NumberUtils;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.strategy.Rule;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Report
extends LinkedHashMap<String, Object>
implements Serializable {
    private String desc;
    private String name;

    public Report avgReport(List<Report> reportList) {
        HashMap<String, Double> sums = new HashMap<String, Double>();
        for (Report report : reportList) {
            this.eachReport(report, (fieldName, item) -> {
                Object value = item.value;
                if (sums.containsKey(fieldName)) {
                    Object fieldValue = sums.get(fieldName);
                    if (fieldValue instanceof Number && value instanceof Number) {
                        sums.replace(fieldName, ((Number)fieldValue).doubleValue() + ((Number)value).doubleValue());
                    }
                } else if (value instanceof Number) {
                    sums.put(fieldName, ((Number)value).doubleValue());
                }
                return item;
            });
        }
        for (Map.Entry entry : sums.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Number) || reportList.isEmpty()) continue;
            sums.replace((String)entry.getKey(), NumberUtils.scale((Number)(((Number)value).doubleValue() / (double)reportList.size()), (int)2));
        }
        Report report = reportList.get(reportList.size() - 1).clone();
        this.eachReport(report, (fieldName, item) -> {
            if (item.value instanceof Number) {
                item.setValue(sums.get(fieldName));
            }
            return item;
        });
        return report;
    }

    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder(String.format("<b>[%s(%s)]</b>\r\n", this.getName(), this.getDesc()));
        for (Map.Entry item : this.entrySet()) {
            Object value = item.getValue();
            if (value instanceof ReportItem) {
                ReportItem reportItem = (ReportItem)value;
                Object itemValue = reportItem.getValue();
                if (Objects.nonNull(itemValue)) {
                    if (itemValue instanceof Number) {
                        itemValue = NumberUtils.scale((Number)((Number)itemValue), (int)2);
                    } else if (itemValue instanceof String) {
                        String text = StringUtils.nullToEmpty((Object)itemValue);
                        if (((String)item.getKey()).contains(".detail") && !text.isEmpty()) {
                            itemValue = "<span style='color:blue;cursor:pointer' title='{title}' onclick='this.innerHTML=(this.textContent==\"\u663e\u793a\u8be6\u60c5\"?this.title.replace(/\\r/g,\"\").replace(/\\n/g,\"<br/>\"):\"\u663e\u793a\u8be6\u60c5\");'>\u663e\u793a\u8be6\u60c5</span>".replace("{title}", this.htmlEncode(text).replace("\r", "/r").replace("\n", "/n"));
                        }
                    } else {
                        itemValue = JsonUtils.toJSONString((Object)itemValue);
                    }
                } else {
                    itemValue = "NULL";
                }
                stringBuilder.append(String.format("%s(%s):%s%s\r\n", item.getKey(), reportItem.getDesc(), itemValue, reportItem.isWarn() ? "<font color=\"#FF0000\">[\u62a5\u8b66]</font>" : ""));
                continue;
            }
            if (!(value instanceof Report)) continue;
            stringBuilder.append(((Report)value).toHtml());
        }
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    public String htmlEncode(String source) {
        if (source == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        block7: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buffer.append("&apos;");
                    continue block7;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public String toJson() {
        return JsonUtils.toJSONString((Object)this);
    }

    public void eachReport(ReportItemEachCallBack callBack) {
        this.eachReport(this, callBack);
    }

    public ReportItem getByKey(String key) {
        for (Map.Entry item : this.entrySet()) {
            Report report;
            ReportItem reportItem;
            Object value = item.getValue();
            String key1 = (String)item.getKey();
            if (key1.equals(key) && value instanceof ReportItem) {
                ReportItem reportItem2 = (ReportItem)value;
                return reportItem2;
            }
            if (!(value instanceof Report) || (reportItem = (report = (Report)value).getByKey(key)) == null) continue;
            return reportItem;
        }
        return null;
    }

    public List<String> getKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry item : this.entrySet()) {
            Object value = item.getValue();
            if (value instanceof ReportItem) {
                list.add((String)item.getKey());
                continue;
            }
            if (!(value instanceof Report)) continue;
            Report report = (Report)value;
            for (Map.Entry stringObjectEntry : report.entrySet()) {
                Object value1 = stringObjectEntry.getValue();
                if (!(value1 instanceof ReportItem)) continue;
                list.add((String)stringObjectEntry.getKey());
            }
        }
        return list;
    }

    private void eachReport(Report report, ReportItemEachCallBack callBack) {
        for (Map.Entry item : report.entrySet()) {
            Object value = item.getValue();
            if (value instanceof ReportItem) {
                callBack.run((String)item.getKey(), (ReportItem)value);
                continue;
            }
            if (!(value instanceof Report)) continue;
            this.eachReport((Report)value, callBack);
        }
    }

    public Report(CollectInfo info) {
        this.parseObject(this, info);
    }

    private void parseObject(Report report, CollectInfo obj) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            Object value;
            FieldReport fieldReport = field.getAnnotation(FieldReport.class);
            if (fieldReport == null || (value = this.tryGet(field, obj)) == null) continue;
            if (value instanceof Number) {
                report.put(fieldReport.name(), new ReportItem(fieldReport.desc(), value, "", null));
                continue;
            }
            if (value instanceof CollectInfo) {
                Report report2 = new Report().setDesc(fieldReport.desc()).setName(fieldReport.name());
                report.put(fieldReport.name(), report2);
                this.parseObject(report2, (CollectInfo)value);
                continue;
            }
            report.put(fieldReport.name(), new ReportItem(fieldReport.desc(), JsonUtils.toJSONString((Object)value), "", null));
        }
    }

    private Object tryGet(Field field, Object obj) {
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Report() {
    }

    @Override
    public Report clone() {
        Report report = new Report().setName(this.name).setDesc(this.desc);
        for (Map.Entry item : this.entrySet()) {
            Object value = item.getValue();
            if (value instanceof ReportItem) {
                report.put((String)item.getKey(), ((ReportItem)value).clone());
                continue;
            }
            if (!(value instanceof Report)) continue;
            report.put((String)item.getKey(), ((Report)value).clone());
        }
        return report;
    }

    public String getDesc() {
        return this.desc;
    }

    public Report setDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Report setName(String name) {
        this.name = name;
        return this;
    }

    public static interface ReportItemEachCallBack {
        public ReportItem run(String var1, ReportItem var2);
    }

    public static class ReportItem
    implements Serializable {
        private String desc;
        private Object value;
        private String warn;
        private transient Rule.RuleInfo rule;

        public ReportItem(String desc, Object value, String warn, Rule.RuleInfo rule) {
            this.desc = desc;
            this.value = value;
            this.warn = warn;
            this.rule = rule;
        }

        public boolean isWarn() {
            return this.warn != null && !this.warn.isEmpty();
        }

        public String toString() {
            return "ReportItem{desc='" + this.desc + "', value=" + String.valueOf(this.value) + ", warn='" + this.warn + "', rule=" + String.valueOf(this.rule) + "}";
        }

        public ReportItem clone() {
            return new ReportItem(this.desc, this.value, this.warn, this.rule);
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getWarn() {
            return this.warn;
        }

        public void setWarn(String warn) {
            this.warn = warn;
        }

        public Rule.RuleInfo getRule() {
            return this.rule;
        }

        public void setRule(Rule.RuleInfo rule) {
            this.rule = rule;
        }
    }
}

