/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.strategy;

import com.taotao.boot.common.utils.common.PropertyUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.monitor.collect.task.IOCollectTask;
import com.taotao.boot.monitor.model.Report;
import com.taotao.boot.monitor.strategy.Rule;
import com.taotao.boot.monitor.strategy.WarnStrategy;
import com.taotao.boot.monitor.strategy.WarnTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultWarnStrategy
implements WarnStrategy {
    protected static int maxCacheSize = 3;
    protected static List<Report> cacheReports = Collections.synchronizedList(new ArrayList(maxCacheSize + 2));
    protected Rule.RulesAnalyzer rulesAnalyzer;
    protected WarnTemplate warnTemplate;

    public Rule.RulesAnalyzer getRulesAnalyzer() {
        return this.rulesAnalyzer;
    }

    public WarnTemplate getWarnTemplate() {
        return this.warnTemplate;
    }

    public DefaultWarnStrategy(WarnTemplate warnTemplate, Rule.RulesAnalyzer rulesAnalyzer) {
        this.warnTemplate = warnTemplate;
        this.rulesAnalyzer = rulesAnalyzer;
        this.setDefaultStrategy();
    }

    public void setDefaultStrategy() {
        this.rulesAnalyzer.registerRules("cpu.process", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.cpu.process", (Object)"[>0.7]"));
        this.rulesAnalyzer.registerRules("cpu.system", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.cpu.system", (Object)"[>0.7]"));
        this.rulesAnalyzer.registerRules("io.current.dir.usable.size", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.io.current.dir.usable.size", (Object)"[<500]"));
        this.rulesAnalyzer.registerRules("memery.jvm.max", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.memery.jvm.max", (Object)"[<256]"));
        this.rulesAnalyzer.registerRules("memery.system.free", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.memery.system.free", (Object)"[<256]"));
        this.rulesAnalyzer.registerRules("thread.deadlocked.count", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.thread.deadlocked.count", (Object)"[>10]"));
        this.rulesAnalyzer.registerRules("thread.total", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.thread.total", (Object)"[>1000]"));
        this.rulesAnalyzer.registerRules("tomcat.threadPool.pool.size.count", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.tomcat.threadPool.pool.size.count", (Object)"[>1000]"));
        this.rulesAnalyzer.registerRules("tomcat.threadPool.active.count", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.tomcat.threadPool.active.count", (Object)"[>200]"));
        this.rulesAnalyzer.registerRules("tomcat.threadPool.queue.size", (String)PropertyUtils.getPropertyCache((String)"ttc.monitor.strategy.tomcat.threadPool.queue.size", (Object)"[>50]"));
        if (this.rulesAnalyzer.getRules("io.current.dir.usable.size") != null) {
            this.rulesAnalyzer.getRules("io.current.dir.usable.size").forEach(c -> {
                if (c.getType() == Rule.RuleType.less) {
                    c.setHitCallBack(value -> IOCollectTask.clearLog());
                }
            });
        }
    }

    @Override
    public Report analyse(Report report) {
        while (cacheReports.size() > maxCacheSize) {
            cacheReports.remove(0);
        }
        cacheReports.add(report);
        Report avgReport = report.avgReport(cacheReports);
        return this.rulesAnalyzer.analyse(avgReport);
    }

    @Override
    public String analyseText(Report report) {
        Report r = this.analyse(report);
        StringBuilder warn = new StringBuilder();
        r.eachReport((filed, item) -> {
            if (item.isWarn()) {
                warn.append(this.warnTemplate.getWarnContent(filed, item.getDesc(), item.getValue(), item.getRule()));
            }
            return item;
        });
        String warnInfo = warn.toString();
        if (StringUtils.isEmpty((String)warnInfo)) {
            return "";
        }
        return warnInfo;
    }
}

