/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.strategy;

import com.taotao.boot.common.model.PropertyCache;
import com.taotao.boot.common.utils.common.PropertyUtils;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.convert.ConvertUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.model.Report;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class Rule {

    public static interface HitCallBack {
        public void run(Object var1);
    }

    public static class RuleParser {
        public List<RuleInfo> parser(String text) {
            ArrayList<RuleInfo> result = new ArrayList<RuleInfo>();
            try {
                if (com.taotao.boot.common.utils.lang.StringUtils.isNotBlank((String)text) && text.startsWith("[") && text.endsWith("]")) {
                    String[] rules;
                    text = text.replace("[", "").replace("]", "");
                    for (String r : rules = text.split(";")) {
                        RuleType type = RuleType.getRuleType("" + r.charAt(0));
                        String value = StringUtils.trimLeadingCharacter((String)r, (char)r.charAt(0));
                        if (type == null) continue;
                        result.add(new RuleInfo(type, value, null));
                    }
                }
            }
            catch (Exception exp) {
                LogUtils.error((String)"health", (Object[])new Object[]{"parser\u89c4\u5219\u89e3\u6790\u51fa\u9519", exp});
            }
            return result;
        }
    }

    public static enum RuleType {
        more(">", "\u5927\u4e8e"),
        less("<", "\u5c0f\u4e8e"),
        equal("=", "\u7b49\u4e8e"),
        contain("%", "\u5305\u542b");

        private final String desc;
        private final String tag;

        private RuleType(String tag, String desc) {
            this.desc = desc;
            this.tag = tag;
        }

        public static RuleType getRuleType(String tag) {
            for (RuleType type : RuleType.values()) {
                if (!type.tag.equalsIgnoreCase(tag)) continue;
                return type;
            }
            return null;
        }
    }

    public static class RulesAnalyzer {
        private final Map<String, List<RuleInfo>> rules = new HashMap<String, List<RuleInfo>>();
        private final RuleParser ruleParser = new RuleParser();

        public RulesAnalyzer() {
            PropertyCache propertyCache = (PropertyCache)ContextUtils.getBean(PropertyCache.class, (boolean)false);
            if (Objects.nonNull(propertyCache)) {
                propertyCache.listenUpdateCache("RulesAnalyzer \u52a8\u6001\u89c4\u5219\u8ba2\u9605", map -> {
                    for (Map.Entry e : map.entrySet()) {
                        List<RuleInfo> rule;
                        String key = (String)e.getKey();
                        if (!StringUtils.startsWithIgnoreCase((String)key, (String)"ttc.monitor.strategy.") || (rule = this.rules.get(key = key.replace("ttc.monitor.strategy.", ""))) == null) continue;
                        this.registerRules(key, com.taotao.boot.common.utils.lang.StringUtils.nullToEmpty(e.getValue()));
                    }
                });
            }
        }

        public List<RuleInfo> parserRules(String rules) {
            return this.ruleParser.parser(rules);
        }

        public List<RuleInfo> getRules(String field) {
            List<RuleInfo> item = this.rules.get(field);
            if (item == null) {
                this.registerRulesByProperties(field);
            }
            return this.rules.get(field);
        }

        public void registerRules(String field, List<RuleInfo> rules) {
            this.rules.put(field, rules);
        }

        public void registerRules(String field, String rules) {
            this.registerRules(field, this.ruleParser.parser(rules));
        }

        public void registerRulesByProperties(String field) {
            String value = (String)PropertyUtils.getPropertyCache((String)("ttc.monitor.strategy." + field), (Object)"");
            this.registerRules(field, value);
        }

        public Report analyse(Report report) {
            report.eachReport((fieldName, item) -> {
                List<RuleInfo> rules = this.getRules(fieldName);
                if (rules != null && !rules.isEmpty()) {
                    for (RuleInfo ruleInfo : rules) {
                        boolean isWarn = ruleInfo.check(item.getValue());
                        if (!isWarn) continue;
                        item.setWarn("\u62a5\u8b66");
                        item.setRule(ruleInfo);
                        if (ruleInfo.getHitCallBack() == null) continue;
                        try {
                            ruleInfo.hitCallBack.run(item.getValue());
                        }
                        catch (Exception exp) {
                            LogUtils.error((String)"health", (Object[])new Object[]{"analyse\u5206\u6790\u65f6\u6267\u884c\u62a5\u8b66\u56de\u8c03\u89c4\u5219\u51fa\u9519", exp});
                        }
                    }
                }
                return item;
            });
            return report;
        }
    }

    public static class RuleInfo
    implements Serializable {
        private RuleType type;
        private Object value;
        private HitCallBack hitCallBack;

        public RuleInfo() {
        }

        public RuleInfo(RuleType type, Object value, HitCallBack hitCallBack) {
            this.type = type;
            this.value = value;
            this.hitCallBack = hitCallBack;
        }

        public boolean check(Object checkValue) {
            if (checkValue == null) {
                return false;
            }
            try {
                if (checkValue instanceof Number) {
                    double checkValue2 = ((Number)checkValue).doubleValue();
                    double warnValue = ((Number)ConvertUtils.convert((Object)this.value, Number.class)).doubleValue();
                    if (this.type == RuleType.less && checkValue2 < warnValue) {
                        return true;
                    }
                    if (this.type == RuleType.more && checkValue2 > warnValue) {
                        return true;
                    }
                    if (this.type == RuleType.equal && checkValue2 == warnValue) {
                        return true;
                    }
                } else {
                    String checkValue2 = checkValue.toString();
                    String warnValue = this.value.toString();
                    if (this.type == RuleType.equal && Objects.equals(checkValue2, warnValue)) {
                        return true;
                    }
                    if (this.type == RuleType.contain && checkValue2.contains(warnValue)) {
                        return true;
                    }
                }
            }
            catch (Exception exp) {
                LogUtils.error((String)"health", (Object[])new Object[]{"check \u89c4\u5219\u68c0\u67e5\u51fa\u9519", exp});
            }
            return false;
        }

        public RuleType getType() {
            return this.type;
        }

        public void setType(RuleType type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public HitCallBack getHitCallBack() {
            return this.hitCallBack;
        }

        public void setHitCallBack(HitCallBack hitCallBack) {
            this.hitCallBack = hitCallBack;
        }
    }
}

