/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.utils;

import com.taotao.boot.common.constant.CommonConstants;
import com.taotao.boot.common.utils.common.PropertyUtils;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.core.enums.ExceptionTypeEnum;
import com.taotao.boot.core.http.DefaultHttpClient;
import com.taotao.boot.core.http.HttpClient;
import com.taotao.boot.monitor.Monitor;
import com.taotao.boot.monitor.enums.WarnLevelEnum;
import com.taotao.boot.monitor.enums.WarnTypeEnum;
import com.taotao.boot.monitor.model.Message;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.ContentType;

public class ExceptionUtils {
    private static final String exceptionUrl = "taotao.boot.monitor.report.exception.url";

    public static void reportException(Message message, String applicationName) {
        if (message.getWarnType() == WarnTypeEnum.ERROR) {
            AtomicReference<String> title = new AtomicReference<String>(message.getTitle());
            Monitor monitorThreadPool = (Monitor)ContextUtils.getBean(Monitor.class, (boolean)false);
            if (Objects.nonNull(monitorThreadPool)) {
                monitorThreadPool.monitorSubmit("\u7cfb\u7edf\u4efb\u52a1: reportException \u5f02\u5e38\u4e0a\u62a5", () -> {
                    HashMap param = new HashMap();
                    param.put("exceptionTitle", title.get());
                    param.put("exceptionType", message.getExceptionType().getCode());
                    param.put("exceptionLevel", message.getLevelType().getLevel());
                    if (StringUtils.isNotBlank((CharSequence)message.getExceptionCode())) {
                        param.put("exceptionCode", message.getExceptionCode());
                    }
                    if (StringUtils.isNotBlank((CharSequence)message.getBizScope())) {
                        param.put("bizScope", message.getBizScope());
                    }
                    param.put("exceptionContent", String.format("[%s][%s][%s]%s", RequestUtils.getIpAddress(), PropertyUtils.getProperty((String)CommonConstants.SPRING_APP_NAME_KEY), PropertyUtils.getProperty((String)CommonConstants.SPRING_APP_NAME_KEY), message.getContent()));
                    if (StringUtils.isNotBlank((CharSequence)applicationName)) {
                        param.put("applicationName", applicationName);
                    } else {
                        param.put("applicationName", PropertyUtils.getProperty((String)CommonConstants.SPRING_APP_NAME_KEY));
                    }
                    HttpClient.Params params = HttpClient.Params.custom().setContentType(ContentType.APPLICATION_JSON).add(param).build();
                    DefaultHttpClient defaultHttpClient = (DefaultHttpClient)ContextUtils.getBean(DefaultHttpClient.class, (boolean)false);
                    if (Objects.nonNull(defaultHttpClient)) {
                        defaultHttpClient.post((String)PropertyUtils.getPropertyCache((String)exceptionUrl, (Object)""), params);
                    }
                });
            }
        }
    }

    public static void reportException(Message message) {
        ExceptionUtils.reportException(message, null);
    }

    public static void reportException(WarnLevelEnum warnLevelEnum, String title, String content) {
        ExceptionUtils.reportException(new Message(WarnTypeEnum.ERROR, title, content, warnLevelEnum, ExceptionTypeEnum.BE, null, null), null);
    }

    public static void reportException(WarnLevelEnum warnLevelEnumType, String title, String content, String applicationName) {
        ExceptionUtils.reportException(new Message(WarnTypeEnum.ERROR, title, content, warnLevelEnumType, ExceptionTypeEnum.BE, null, null), applicationName);
    }
}

