/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.utils;

import com.taotao.boot.common.utils.log.LogUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;

public class ProcessUtils {
    public static String execCmd(String cmd) {
        if (ProcessUtils.isWinOs()) {
            return "-1";
        }
        try {
            return ProcessUtils.execCmd(cmd, null);
        }
        catch (Exception e) {
            return "-2";
        }
    }

    public static boolean isWinOs() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    public static String getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getName().split("@")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execCmd(String cmd, File dir) {
        StringBuilder result = new StringBuilder();
        Process process = null;
        BufferedReader bufferIn = null;
        try {
            String line;
            String[] commond = new String[]{"sh", "-c", cmd};
            process = Runtime.getRuntime().exec(commond, null, dir);
            process.waitFor(3L, TimeUnit.SECONDS);
            bufferIn = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            while ((line = bufferIn.readLine()) != null) {
                result.append(line).append('\n');
            }
            String string = result.toString();
            ProcessUtils.closeStream(bufferIn);
            if (process != null) {
                process.destroy();
            }
            return string;
        }
        catch (Exception e) {
            LogUtils.error((String)"taotao-boot-starter-monitor", (Object[])new Object[]{"execCmd", e});
        }
        finally {
            ProcessUtils.closeStream(bufferIn);
            if (process != null) {
                process.destroy();
            }
        }
        return "-3";
    }

    private static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
            }
        }
    }
}

