/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.warn;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.core.utils.RequestWebUtils;
import com.taotao.boot.monitor.model.Message;
import com.taotao.boot.monitor.properties.WarnProperties;
import com.taotao.boot.monitor.warn.AbstractWarn;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Objects;

public class DingdingWarn
extends AbstractWarn {
    private static final String CLASS = "com.taotao.boot.dingtalk.model.DingerRobot";
    private static final String MESSAGE_SUB_TYPE = "com.taotao.boot.dingtalk.enums.MessageSubType";
    private static final String DINGER_REQUEST = "com.taotao.boot.dingtalk.entity.DingerRequest";
    private final boolean driverExist = ReflectionUtils.tryClassForName((String)"com.taotao.boot.dingtalk.model.DingerRobot") != null;

    @Override
    public void notify(Message message) {
        if (!this.driverExist) {
            LogUtils.error((String)"\u672a\u627e\u5230DingerRobot, \u4e0d\u652f\u6301\u9489\u9489\u9884\u8b66", (Object[])new Object[0]);
            return;
        }
        WarnProperties warnProperties = (WarnProperties)ContextUtils.getBean(WarnProperties.class, (boolean)true);
        Object dingerRobot = ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)CLASS), (boolean)true);
        if (dingerRobot != null) {
            String ip = RequestUtils.getIpAddress();
            String dingDingFilterIP = warnProperties.getDingdingFilterIP();
            if (!StringUtils.isEmpty((String)ip) && !dingDingFilterIP.contains(ip)) {
                String title = "[" + message.getWarnType().getDescription() + "]" + StringUtils.subString3((String)message.getTitle(), (int)100);
                String context = StringUtils.subString3((String)message.getTitle(), (int)100) + "\n\u8be6\u60c5: " + RequestWebUtils.getBaseUrl() + "/health/\n" + StringUtils.subString3((String)message.getContent(), (int)500);
                try {
                    Object messageSubType = ReflectionUtils.findEnumObjByName((Class)Objects.requireNonNull(ReflectionUtils.tryClassForName((String)MESSAGE_SUB_TYPE)), (String)"name", (String)"TEXT");
                    ArrayList<CallSite> requestParam = new ArrayList<CallSite>();
                    requestParam.add((CallSite)((Object)context));
                    requestParam.add((CallSite)((Object)title));
                    Object request = ReflectionUtils.callMethod((Class)ReflectionUtils.tryClassForName((String)DINGER_REQUEST), (String)"request", (Object[])requestParam.toArray());
                    ArrayList<Object> param = new ArrayList<Object>();
                    param.add(messageSubType);
                    param.add(request);
                    ReflectionUtils.callMethod((Object)dingerRobot, (String)"send", (Object[])param.toArray());
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        }
    }
}

