/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.warn;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.core.utils.RequestWebUtils;
import com.taotao.boot.monitor.model.Message;
import com.taotao.boot.monitor.properties.WarnProperties;
import com.taotao.boot.monitor.warn.AbstractWarn;
import java.util.ArrayList;
import java.util.Objects;

public class MailWarn
extends AbstractWarn {
    private static final String CLASS = "com.taotao.boot.mail.template.MailTemplate";
    private final boolean driverExist = ReflectionUtils.tryClassForName((String)"com.taotao.boot.mail.template.MailTemplate") != null;

    @Override
    public void notify(Message message) {
        if (!this.driverExist) {
            LogUtils.error((String)"\u672a\u627e\u5230MailTemplate, \u4e0d\u652f\u6301\u90ae\u4ef6\u9884\u8b66", (Object[])new Object[0]);
            return;
        }
        WarnProperties warnProperties = (WarnProperties)ContextUtils.getBean(WarnProperties.class, (boolean)true);
        Object mailTemplate = ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)CLASS), (boolean)true);
        if (Objects.nonNull(mailTemplate) && Objects.nonNull(warnProperties)) {
            String ip = RequestUtils.getIpAddress();
            String dingDingFilterIP = warnProperties.getDingdingFilterIP();
            if (!StringUtils.isEmpty((String)ip) && !dingDingFilterIP.contains(ip)) {
                String context = StringUtils.subString3((String)message.getTitle(), (int)100) + "\n\u8be6\u60c5: " + RequestWebUtils.getBaseUrl() + "/health/\n" + StringUtils.subString3((String)message.getContent(), (int)500);
                try {
                    ArrayList<Object> param = new ArrayList<Object>();
                    param.add("981376577@qq.com");
                    param.add("\u670d\u52a1\u72b6\u6001\u9884\u8b66");
                    param.add(context);
                    ReflectionUtils.callMethod((Object)mailTemplate, (String)"sendSimpleMail", (Object[])param.toArray());
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        }
    }
}

