/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.warn;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.core.utils.RequestWebUtils;
import com.taotao.boot.monitor.model.Message;
import com.taotao.boot.monitor.properties.WarnProperties;
import com.taotao.boot.monitor.warn.AbstractWarn;
import java.util.ArrayList;
import java.util.Objects;

public class SmsWarn
extends AbstractWarn {
    private static final String CLASS = "com.taotao.boot.sms.service.SmsService";
    private final boolean driverExist = ReflectionUtils.tryClassForName((String)"com.taotao.boot.sms.service.SmsService") != null;

    @Override
    public void notify(Message message) {
        if (!this.driverExist) {
            LogUtils.error((String)"\u672a\u627e\u5230SmsService, \u4e0d\u652f\u6301\u77ed\u4fe1\u9884\u8b66", (Object[])new Object[0]);
            return;
        }
        WarnProperties warnProperties = (WarnProperties)ContextUtils.getBean(WarnProperties.class, (boolean)true);
        Object smsService = ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)CLASS), (boolean)true);
        if (Objects.nonNull(warnProperties) && Objects.nonNull(smsService)) {
            String ip = RequestUtils.getIpAddress();
            String dingDingFilterIP = warnProperties.getDingdingFilterIP();
            if (!StringUtils.isEmpty((String)ip) && !dingDingFilterIP.contains(ip)) {
                String context = StringUtils.subString3((String)message.getTitle(), (int)100) + "\n\u8be6\u60c5: " + RequestWebUtils.getBaseUrl() + "/taotao/cloud/health/\n" + StringUtils.subString3((String)message.getContent(), (int)500);
                try {
                    ArrayList<Object> param = new ArrayList<Object>();
                    param.add("phoneNumber");
                    param.add("signName");
                    param.add("templateCode");
                    param.add(context);
                    ReflectionUtils.callMethod((Object)smsService, (String)"sendSms", (Object[])param.toArray());
                }
                catch (Exception e) {
                    LogUtils.error((Throwable)e);
                }
            }
        }
    }
}

