/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.oss.common.service;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.oss.common.constant.OssConstant;
import com.taotao.boot.oss.common.exception.OssException;
import com.taotao.boot.oss.common.model.OssInfo;
import com.taotao.boot.oss.common.model.SliceConfig;
import com.taotao.boot.oss.common.model.UploadFileInfo;
import com.taotao.boot.oss.common.model.download.DownloadCheckPoint;
import com.taotao.boot.oss.common.model.download.DownloadObjectStat;
import com.taotao.boot.oss.common.model.download.DownloadPart;
import com.taotao.boot.oss.common.model.download.DownloadPartResult;
import com.taotao.boot.oss.common.model.upload.UpLoadCheckPoint;
import com.taotao.boot.oss.common.model.upload.UpLoadPartEntityTag;
import com.taotao.boot.oss.common.model.upload.UpLoadPartResult;
import com.taotao.boot.oss.common.model.upload.UploadPart;
import com.taotao.boot.oss.common.util.FileUtil;
import com.taotao.boot.oss.common.util.OssPathUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.springframework.web.multipart.MultipartFile;

public interface StandardOssClient {
    default public OssInfo upLoadWithMultipartFile(MultipartFile multipartFile) {
        try {
            UploadFileInfo uploadFileInfo = FileUtil.getMultipartFileInfo(multipartFile);
            OssInfo ossInfo = this.upLoadWithInputStream(multipartFile.getInputStream(), OssPathUtil.getTargetName(multipartFile));
            ossInfo.setUploadFileInfo(uploadFileInfo);
            return ossInfo;
        }
        catch (IOException e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    default public OssInfo upLoadWithPath(String path) {
        return this.upLoadWithFile(new File(path));
    }

    default public OssInfo upLoadWithFile(File file) {
        try {
            UploadFileInfo uploadFileInfo = FileUtil.getFileInfo(file);
            OssInfo ossInfo = this.upLoadWithInputStream(new FileInputStream(file), OssPathUtil.getTargetName(file));
            ossInfo.setUploadFileInfo(uploadFileInfo);
            return ossInfo;
        }
        catch (IOException e) {
            LogUtils.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    default public OssInfo upLoadWithInputStream(InputStream is, String targetName) {
        return this.upLoad(is, targetName, true);
    }

    public OssInfo upLoad(InputStream var1, String var2, Boolean var3);

    default public OssInfo upLoadCheckPoint(String file, String targetName) {
        return this.upLoadCheckPoint(new File(file), targetName);
    }

    default public OssInfo upLoadCheckPoint(String filePath) {
        File file = new File(filePath);
        return this.upLoadCheckPoint(file, OssPathUtil.getTargetName(file));
    }

    public OssInfo upLoadCheckPoint(File var1, String var2);

    default public OssInfo uploadFile(File upLoadFile, String targetName, SliceConfig slice, String ossType) {
        String checkpointFile = upLoadFile.getPath() + "." + ossType;
        UpLoadCheckPoint upLoadCheckPoint = new UpLoadCheckPoint();
        try {
            upLoadCheckPoint.load(checkpointFile);
        }
        catch (Exception e) {
            FileUtil.deleteFile(checkpointFile);
        }
        if (!upLoadCheckPoint.isValid()) {
            this.prepareUpload(upLoadCheckPoint, upLoadFile, targetName, checkpointFile, slice);
            FileUtil.deleteFile(checkpointFile);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(slice.getTaskNum());
        ArrayList<Future<UpLoadPartResult>> futures = new ArrayList<Future<UpLoadPartResult>>();
        for (int i = 0; i < upLoadCheckPoint.getUploadParts().size(); ++i) {
            if (upLoadCheckPoint.getUploadParts().get(i).isCompleted()) continue;
            futures.add(executorService.submit(new UploadPartTask(this, upLoadCheckPoint, i)));
        }
        executorService.shutdown();
        for (Future future : futures) {
            try {
                UpLoadPartResult partResult = (UpLoadPartResult)future.get();
                if (!partResult.isFailed()) continue;
                throw partResult.getException();
            }
            catch (Exception e) {
                throw new OssException(e);
            }
        }
        try {
            if (!executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new OssException("\u5173\u95ed\u7ebf\u7a0b\u6c60\u5931\u8d25", (Throwable)e);
        }
        List<UpLoadPartEntityTag> partEntityTags = upLoadCheckPoint.getPartEntityTags();
        this.completeUpload(upLoadCheckPoint, partEntityTags);
        return this.getInfo(targetName);
    }

    default public void completeUpload(UpLoadCheckPoint upLoadCheckPoint, List<UpLoadPartEntityTag> partEntityTags) {
        FileUtil.deleteFile(upLoadCheckPoint.getCheckpointFile());
    }

    default public void prepareUpload(UpLoadCheckPoint uploadCheckPoint, File upLoadFile, String targetName, String checkpointFile, SliceConfig slice) {
        throw new OssException("\u521d\u59cb\u5316\u65ad\u70b9\u7eed\u4f20\u5bf9\u8c61\u672a\u5b9e\u73b0\uff0c\u9ed8\u8ba4\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    default public ArrayList<UploadPart> splitUploadFile(long fileSize, long partSize) {
        ArrayList<UploadPart> parts = new ArrayList<UploadPart>();
        long partNum = fileSize / partSize;
        if (partNum >= OssConstant.DEFAULT_PART_NUM) {
            partSize = fileSize / (OssConstant.DEFAULT_PART_NUM - 1L);
            partNum = fileSize / partSize;
        }
        for (long i = 0L; i < partNum; ++i) {
            UploadPart part = new UploadPart();
            part.setNumber((int)(i + 1L));
            part.setOffset(i * partSize);
            part.setSize(partSize);
            part.setCompleted(false);
            parts.add(part);
        }
        if (fileSize % partSize > 0L) {
            UploadPart part = new UploadPart();
            part.setNumber(parts.size() + 1);
            part.setOffset((long)parts.size() * partSize);
            part.setSize(fileSize % partSize);
            part.setCompleted(false);
            parts.add(part);
        }
        return parts;
    }

    default public UpLoadPartResult uploadPart(UpLoadCheckPoint upLoadCheckPoint, int partNum, InputStream inputStream) {
        UploadPart uploadPart = upLoadCheckPoint.getUploadParts().get(partNum);
        long partSize = uploadPart.getSize();
        UpLoadPartResult partResult = new UpLoadPartResult(partNum + 1, uploadPart.getOffset(), partSize);
        partResult.setFailed(true);
        return partResult;
    }

    public void downLoad(OutputStream var1, String var2);

    default public void downLoadCheckPoint(String localFile, String targetName) {
        this.downLoadCheckPoint(new File(localFile), targetName);
    }

    public void downLoadCheckPoint(File var1, String var2);

    default public void downLoadFile(File localFile, String targetName, SliceConfig slice, String ossType) {
        String checkpointFile = localFile.getPath() + "." + ossType;
        DownloadCheckPoint downloadCheckPoint = new DownloadCheckPoint();
        try {
            downloadCheckPoint.load(checkpointFile);
        }
        catch (Exception e) {
            FileUtil.deleteFile(checkpointFile);
        }
        DownloadObjectStat downloadObjectStat = this.getDownloadObjectStat(targetName);
        if (!downloadCheckPoint.isValid(downloadObjectStat)) {
            this.prepareDownload(downloadCheckPoint, localFile, targetName, checkpointFile);
            FileUtil.deleteFile(checkpointFile);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(slice.getTaskNum());
        ArrayList<Future<DownloadPartResult>> futures = new ArrayList<Future<DownloadPartResult>>();
        for (int i = 0; i < downloadCheckPoint.getDownloadParts().size(); ++i) {
            if (downloadCheckPoint.getDownloadParts().get(i).isCompleted()) continue;
            futures.add(executorService.submit(new DownloadPartTask(this, downloadCheckPoint, i)));
        }
        executorService.shutdown();
        for (Future future : futures) {
            try {
                DownloadPartResult partResult = (DownloadPartResult)future.get();
                if (!partResult.isFailed()) continue;
                throw partResult.getException();
            }
            catch (Exception e) {
                throw new OssException(e);
            }
        }
        try {
            if (!executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            throw new OssException("\u5173\u95ed\u7ebf\u7a0b\u6c60\u5931\u8d25", (Throwable)e);
        }
        org.dromara.hutool.core.io.file.FileUtil.rename((File)new File(downloadCheckPoint.getTempDownloadFile()), (String)downloadCheckPoint.getDownloadFile(), (boolean)true);
        org.dromara.hutool.core.io.file.FileUtil.del((String)downloadCheckPoint.getCheckPointFile());
    }

    default public DownloadObjectStat getDownloadObjectStat(String targetName) {
        throw new OssException("\u83b7\u53d6\u4e0b\u8f7d\u5bf9\u8c61\u72b6\u6001\u65b9\u6cd5\u672a\u5b9e\u73b0\uff0c\u9ed8\u8ba4\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    default public void prepareDownload(DownloadCheckPoint downloadCheckPoint, File localFile, String targetName, String checkpointFile) {
        throw new OssException("\u521d\u59cb\u5316\u65ad\u70b9\u7eed\u4f20\u4e0b\u8f7d\u5bf9\u8c61\u65b9\u6cd5\u672a\u5b9e\u73b0\uff0c\u9ed8\u8ba4\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    default public ArrayList<DownloadPart> splitDownloadFile(long start, long objectSize, long partSize) {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        long partNum = objectSize / partSize;
        if (partNum >= OssConstant.DEFAULT_PART_NUM) {
            partSize = objectSize / (OssConstant.DEFAULT_PART_NUM - 1L);
        }
        long offset = 0L;
        int i = 0;
        while (offset < objectSize) {
            DownloadPart part = new DownloadPart();
            part.setIndex(i);
            part.setStart(offset + start);
            part.setEnd(this.getPartEnd(offset, objectSize, partSize) + start);
            part.setFileStart(offset);
            parts.add(part);
            offset += partSize;
            ++i;
        }
        return parts;
    }

    default public long getPartEnd(long begin, long total, long per) {
        if (begin + per > total) {
            return total - 1L;
        }
        return begin + per - 1L;
    }

    default public ArrayList<DownloadPart> splitDownloadOneFile() {
        ArrayList<DownloadPart> parts = new ArrayList<DownloadPart>();
        DownloadPart part = new DownloadPart();
        part.setIndex(0);
        part.setStart(0L);
        part.setEnd(-1L);
        part.setFileStart(0L);
        parts.add(part);
        return parts;
    }

    default public long[] getDownloadSlice(long[] range, long totalSize) {
        long start = 0L;
        long size = totalSize;
        if (!(range == null || range.length != 2 || totalSize < 1L || range[0] < 0L && range[1] < 0L || range[0] > 0L && range[1] > 0L && range[0] > range[1] || range[0] >= totalSize)) {
            long begin = range[0];
            long end = range[1];
            if (range[0] < 0L) {
                begin = 0L;
            }
            if (range[1] < 0L || range[1] >= totalSize) {
                end = totalSize - 1L;
            }
            start = begin;
            size = end - begin + 1L;
        }
        return new long[]{start, size};
    }

    default public void createDownloadTemp(String downloadTempFile, long length) {
        File file = new File(downloadTempFile);
        RandomAccessFile rf = null;
        try {
            rf = new RandomAccessFile(file, "rw");
            rf.setLength(length);
        }
        catch (Exception e) {
            try {
                throw new OssException("\u521b\u5efa\u4e0b\u8f7d\u7f13\u5b58\u6587\u4ef6\u5931\u8d25");
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rf});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rf});
    }

    default public InputStream downloadPart(String key, long start, long end) throws Exception {
        throw new OssException("\u4e0b\u8f7d\u6587\u4ef6\u5206\u7247\u65b9\u6cd5\u672a\u5b9e\u73b0\uff0c\u9ed8\u8ba4\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5");
    }

    public void delete(String var1);

    default public void copy(String sourceName, String targetName) {
        this.copy(sourceName, targetName, true);
    }

    public void copy(String var1, String var2, Boolean var3);

    default public void move(String sourceName, String targetName) {
        this.move(sourceName, targetName, true);
    }

    default public void move(String sourceName, String targetName, Boolean isOverride) {
        this.copy(sourceName, targetName, isOverride);
        this.delete(sourceName);
    }

    default public void rename(String sourceName, String targetName) {
        this.rename(sourceName, targetName, true);
    }

    default public void rename(String sourceName, String targetName, Boolean isOverride) {
        this.move(sourceName, targetName, isOverride);
    }

    default public OssInfo getInfo(String targetName) {
        return this.getInfo(targetName, false);
    }

    public OssInfo getInfo(String var1, Boolean var2);

    default public Boolean isExist(String targetName) {
        OssInfo info = this.getInfo(targetName);
        return ObjUtil.isNotEmpty((Object)info) && ObjUtil.isNotEmpty((Object)info.getName());
    }

    default public Boolean isFile(String targetName) {
        String name = FileNameUtil.getName((String)targetName);
        return StrUtil.indexOf((CharSequence)name, (char)'.') > 0;
    }

    default public Boolean isDirectory(String targetName) {
        return this.isFile(targetName) == false;
    }

    public Map<String, Object> getClientObject();

    default public String getKey(String targetName, Boolean isAbsolute) {
        String key = OssPathUtil.convertPath(this.getBasePath() + targetName, isAbsolute);
        if (org.dromara.hutool.core.io.file.FileUtil.isWindows() && isAbsolute.booleanValue() && key.contains(":") && key.startsWith("/")) {
            key = key.substring(1);
        }
        return key;
    }

    public String getBasePath();

    public static class UploadPartTask
    implements Callable<UpLoadPartResult> {
        private StandardOssClient ossClient;
        private UpLoadCheckPoint upLoadCheckPoint;
        private int partNum;

        public UploadPartTask(StandardOssClient ossClient, UpLoadCheckPoint upLoadCheckPoint, int partNum) {
            this.ossClient = ossClient;
            this.upLoadCheckPoint = upLoadCheckPoint;
            this.partNum = partNum;
        }

        @Override
        public UpLoadPartResult call() {
            BufferedInputStream inputStream = org.dromara.hutool.core.io.file.FileUtil.getInputStream((String)this.upLoadCheckPoint.getUploadFile());
            UpLoadPartResult upLoadPartResult = this.ossClient.uploadPart(this.upLoadCheckPoint, this.partNum, inputStream);
            if (!upLoadPartResult.isFailed()) {
                this.upLoadCheckPoint.update(this.partNum, upLoadPartResult.getEntityTag(), true);
                this.upLoadCheckPoint.dump();
            }
            return upLoadPartResult;
        }

        public StandardOssClient getOssClient() {
            return this.ossClient;
        }

        public void setOssClient(StandardOssClient ossClient) {
            this.ossClient = ossClient;
        }

        public UpLoadCheckPoint getUpLoadCheckPoint() {
            return this.upLoadCheckPoint;
        }

        public void setUpLoadCheckPoint(UpLoadCheckPoint upLoadCheckPoint) {
            this.upLoadCheckPoint = upLoadCheckPoint;
        }

        public int getPartNum() {
            return this.partNum;
        }

        public void setPartNum(int partNum) {
            this.partNum = partNum;
        }
    }

    public static class DownloadPartTask
    implements Callable<DownloadPartResult> {
        StandardOssClient ossClient;
        DownloadCheckPoint downloadCheckPoint;
        int partNum;

        public DownloadPartTask(StandardOssClient ossClient, DownloadCheckPoint downloadCheckPoint, int partNum) {
            this.ossClient = ossClient;
            this.downloadCheckPoint = downloadCheckPoint;
            this.partNum = partNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DownloadPartResult call() {
            DownloadPartResult partResult = null;
            RandomAccessFile output = null;
            InputStream content = null;
            try {
                DownloadPart downloadPart = this.downloadCheckPoint.getDownloadParts().get(this.partNum);
                partResult = new DownloadPartResult(this.partNum + 1, downloadPart.getStart(), downloadPart.getEnd());
                output = new RandomAccessFile(this.downloadCheckPoint.getTempDownloadFile(), "rw");
                output.seek(downloadPart.getFileStart());
                content = this.ossClient.downloadPart(this.downloadCheckPoint.getKey(), downloadPart.getStart(), downloadPart.getEnd());
                long partSize = downloadPart.getEnd() - downloadPart.getStart();
                byte[] buffer = new byte[ConvertUtil.toInt((Object)partSize).intValue()];
                int bytesRead = 0;
                while ((bytesRead = content.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                partResult.setLength(downloadPart.getLength());
                this.downloadCheckPoint.update(this.partNum, true);
                this.downloadCheckPoint.dump();
            }
            catch (Exception e) {
                try {
                    partResult.setException(e);
                    partResult.setFailed(true);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{output});
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{content});
                    throw throwable;
                }
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{output});
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{content});
            }
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{output});
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{content});
            return partResult;
        }

        public StandardOssClient getOssClient() {
            return this.ossClient;
        }

        public void setOssClient(StandardOssClient ossClient) {
            this.ossClient = ossClient;
        }

        public DownloadCheckPoint getDownloadCheckPoint() {
            return this.downloadCheckPoint;
        }

        public void setDownloadCheckPoint(DownloadCheckPoint downloadCheckPoint) {
            this.downloadCheckPoint = downloadCheckPoint;
        }

        public int getPartNum() {
            return this.partNum;
        }

        public void setPartNum(int partNum) {
            this.partNum = partNum;
        }
    }
}

