/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.guava;

import com.google.common.util.concurrent.RateLimiter;
import com.taotao.boot.common.enums.ResultEnum;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.ratelimit.guava.GuavaLimit;
import com.taotao.boot.ratelimit.guava.GuavaLimitException;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class GuavaLimitAspect {
    private final ConcurrentHashMap<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap();

    @Around(value="@annotation(guavaLimit)")
    public Object around(ProceedingJoinPoint joinPoint, GuavaLimit guavaLimit) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        RateLimiter rateLimiter = this.rateLimiterMap.get(methodSignature.toString());
        if (rateLimiter == null) {
            rateLimiter = RateLimiter.create((double)guavaLimit.token());
            this.rateLimiterMap.put(methodSignature.toString(), rateLimiter);
        }
        if (!rateLimiter.tryAcquire()) {
            return guavaLimit.message();
        }
        try {
            return joinPoint.proceed();
        }
        catch (Throwable e) {
            LogUtils.error((Throwable)e);
            throw new GuavaLimitException(ResultEnum.ERROR);
        }
    }
}

