/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.other.core.support.config;

import com.taotao.boot.ratelimit.other.api.dto.RateLimitConfigDto;
import com.taotao.boot.ratelimit.other.api.support.IRateLimitConfigService;
import com.taotao.boot.ratelimit.other.core.annotation.RateLimit;
import com.taotao.boot.ratelimit.other.core.annotation.RateLimits;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;

public class RateLimitConfigService
implements IRateLimitConfigService {
    @Override
    public List<RateLimitConfigDto> queryConfigList(String tokenId, String methodId, Method method) {
        RateLimits clazzRateLimits;
        RateLimits methodRateLimits;
        RateLimit methodRateLimit = method.getAnnotation(RateLimit.class);
        List<RateLimitConfigDto> methodConfigList = this.buildConfigList(methodRateLimit, methodRateLimits = method.getAnnotation(RateLimits.class));
        if (CollUtil.isNotEmpty(methodConfigList)) {
            return methodConfigList;
        }
        Class<?> clazz = method.getDeclaringClass();
        RateLimit clazzRateLimit = clazz.getAnnotation(RateLimit.class);
        List<RateLimitConfigDto> clazzConfigList = this.buildConfigList(clazzRateLimit, clazzRateLimits = clazz.getAnnotation(RateLimits.class));
        if (CollUtil.isNotEmpty(clazzConfigList)) {
            return clazzConfigList;
        }
        return Collections.emptyList();
    }

    private List<RateLimitConfigDto> buildConfigList(RateLimit rateLimit, RateLimits rateLimits) {
        Object[] rateLimitsArray;
        ArrayList<RateLimitConfigDto> resultList = new ArrayList<RateLimitConfigDto>();
        RateLimitConfigDto rateLimitConfig = this.buildConfig(rateLimit);
        if (rateLimitConfig != null) {
            resultList.add(rateLimitConfig);
        }
        if (rateLimits != null && ArrayUtil.isNotEmpty((Object[])(rateLimitsArray = rateLimits.value()))) {
            for (Object limit : rateLimitsArray) {
                RateLimitConfigDto configDto = this.buildConfig((RateLimit)limit);
                if (configDto == null) continue;
                resultList.add(configDto);
            }
        }
        return resultList;
    }

    private RateLimitConfigDto buildConfig(RateLimit rateLimit) {
        if (rateLimit == null) {
            return null;
        }
        RateLimitConfigDto configDto = new RateLimitConfigDto();
        configDto.setCount(rateLimit.count());
        configDto.setInterval(rateLimit.interval());
        configDto.setPermits(rateLimit.value());
        configDto.setTimeUnit(rateLimit.timeUnit());
        configDto.setEnable(rateLimit.enable());
        return configDto;
    }
}

