/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.other.spring.aop;

import com.taotao.boot.common.utils.aop.AopUtils;
import com.taotao.boot.ratelimit.other.core.bs.RateLimitBs;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RateLimitAspect {
    private final RateLimitBs rateLimitBs;

    public RateLimitAspect(RateLimitBs rateLimitBs) {
        this.rateLimitBs = rateLimitBs;
    }

    @Pointcut(value="@annotation(com.taotao.boot.ratelimit.other.core.annotation.RateLimit) || @annotation(com.taotao.boot.ratelimit.other.core.annotation.RateLimits)")
    public void methodMyPointcut() {
    }

    @Pointcut(value="@within(com.taotao.boot.ratelimit.other.core.annotation.RateLimit) || @within(com.taotao.boot.ratelimit.other.core.annotation.RateLimits)")
    public void classMyPointcut() {
    }

    @Around(value="methodMyPointcut() || classMyPointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Method method = AopUtils.getMethod((JoinPoint)point);
        Object[] args = point.getArgs();
        this.rateLimitBs.tryAcquire(method, args);
        return point.proceed();
    }
}

