/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.other1;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.ratelimit.other1.LimitAspect;
import com.taotao.boot.ratelimit.other1.LimitProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={LimitProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.ratelimit", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LimitAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(LimitAutoConfiguration.class, (String)"taotao-boot-starter-ratelimit", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnClass(value={RedisRepository.class})
    @ConditionalOnBean(value={RedisRepository.class})
    public LimitAspect limitAspect(RedisRepository redisRepository) {
        return new LimitAspect(redisRepository);
    }
}

