/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.other2;

import com.taotao.boot.ratelimit.other1.LimitProperties;
import com.taotao.boot.ratelimit.other2.BizKeyProvider;
import com.taotao.boot.ratelimit.other2.RateLimitAspectHandler;
import com.taotao.boot.ratelimit.other2.RateLimiterService;
import org.redisson.api.RedissonClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={LimitProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.ratelimit", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfiguration(after={RedisAutoConfiguration.class})
public class RateLimiterAutoConfiguration {
    @Bean
    public BizKeyProvider bizKeyProvider() {
        return new BizKeyProvider();
    }

    @Bean
    public RateLimiterService rateLimiterService(BizKeyProvider bizKeyProvider) {
        return new RateLimiterService(bizKeyProvider);
    }

    @Configuration
    @ConditionalOnClass(value={RedissonClient.class})
    public static class RateLimitAspectHandlerConfiguration {
        @Bean
        public RateLimitAspectHandler rateLimitAspectHandler(RedissonClient client, RateLimiterService rateLimiterService) {
            return new RateLimitAspectHandler(client, rateLimiterService);
        }
    }
}

