/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.other3.aspect;

import com.taotao.boot.ratelimit.other3.annotation.SlideWindowLimit;
import com.taotao.boot.ratelimit.other3.exception.EnhanceRedisLimitException;
import com.taotao.boot.ratelimit.other3.helper.RedisLimitHelper;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Aspect
@Component
public class SlideWindowLimitAspect {
    private static final String DOT = ".";
    private final RedisLimitHelper redisLimitHelper;

    public SlideWindowLimitAspect(RedisLimitHelper redisLimitHelper) {
        this.redisLimitHelper = redisLimitHelper;
    }

    @Pointcut(value="@annotation(com.taotao.boot.ratelimit.other3.annotation.SlideWindowLimit)")
    public void aspect() {
    }

    @Around(value="aspect() && @annotation(limit)")
    public Object interceptor(ProceedingJoinPoint proceedingJoinPoint, SlideWindowLimit limit) throws Throwable {
        Object limitKey;
        if (StringUtils.isBlank((CharSequence)limit.limitKey())) {
            MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
            limitKey = signature.getDeclaringTypeName() + DOT + signature.getMethod().getName();
        } else {
            limitKey = limit.limitKey();
        }
        Boolean pass = this.redisLimitHelper.windowLimit((String)limitKey, limit.maxRequest(), limit.timeRequest());
        if (!pass.booleanValue()) {
            throw new EnhanceRedisLimitException("Congestion requested, please try again later.");
        }
        Object result = proceedingJoinPoint.proceed();
        return result;
    }
}

