/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.redisson;

import com.taotao.boot.common.support.expression.ExpressionResolver;
import com.taotao.boot.common.support.expression.spring.SpringExpressionResolver;
import com.taotao.boot.common.utils.servlet.RequestUtils;
import com.taotao.boot.ratelimit.redisson.LimitExecutor;
import com.taotao.boot.ratelimit.redisson.annotation.Limit;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class LimitSupport {
    private final ExpressionResolver resolver = new SpringExpressionResolver();
    private final LimitExecutor limitExecutor;

    public LimitSupport(LimitExecutor limitExecutor) {
        this.limitExecutor = limitExecutor;
    }

    public boolean exec(Limit limit, Method method, Object[] args) {
        String key = limit.key();
        int rate = limit.rate();
        int rateInterval = limit.rateInterval();
        TimeUnit unit = limit.rateIntervalUnit();
        Object spELKey = this.resolver.evaluate(key, method, args);
        if (limit.restrictIp()) {
            String ip = RequestUtils.getIpAddress();
            spELKey = (String)spELKey + "#" + ip;
        }
        return this.limitExecutor.tryAccess((String)spELKey, rate, Duration.ofMillis(unit.toMillis(rateInterval)));
    }
}

