/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.redisson.interceptor;

import com.taotao.boot.common.support.aop.AnnotationAbstractPointcutTypeAdvisor;
import com.taotao.boot.ratelimit.redisson.LimitExecutor;
import com.taotao.boot.ratelimit.redisson.LimitSupport;
import com.taotao.boot.ratelimit.redisson.annotation.Limit;
import com.taotao.boot.ratelimit.redisson.exception.LimitException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.ObjectProvider;

public class LimitInterceptor
extends AnnotationAbstractPointcutTypeAdvisor<Limit> {
    private final ObjectProvider<LimitExecutor> provider;

    public LimitInterceptor(ObjectProvider<LimitExecutor> provider) {
        this.provider = provider;
    }

    protected Object invoke(MethodInvocation invocation, Limit limit) throws Throwable {
        LimitSupport limitSupport = new LimitSupport((LimitExecutor)this.provider.getIfAvailable());
        boolean status = limitSupport.exec(limit, invocation.getMethod(), invocation.getArguments());
        if (status) {
            return invocation.proceed();
        }
        throw new LimitException("key=" + limit.key() + " is reach max limited access count=" + limit.rate() + " within period=" + limit.rateInterval() + " " + limit.rateIntervalUnit().name());
    }
}

