/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.ratelimit.snowjean.config.annotation.aspect;

import com.taotao.boot.ratelimit.snowjean.config.annotation.entity.Limiter;
import com.taotao.boot.ratelimit.snowjean.core.limiter.RateLimiter;
import com.taotao.boot.ratelimit.snowjean.core.observer.RateLimiterObserver;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class RateLimiterAspect {
    @Pointcut(value="@annotation(com.taotao.boot.ratelimit.snowjean.snowjeanspringbootstarter.annotation.entity.Limiter)")
    public void pointcut() {
    }

    @Around(value="pointcut() && @annotation(limiter)")
    public Object around(ProceedingJoinPoint pjp, Limiter limiter) throws Throwable {
        RateLimiter rateLimiter = RateLimiterObserver.getMap().get(limiter.value());
        if (rateLimiter.tryAcquire()) {
            return pjp.proceed();
        }
        Signature sig = pjp.getSignature();
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("This annotation can only be used in methods.");
        }
        MethodSignature msg = (MethodSignature)sig;
        Object target = pjp.getTarget();
        Method fallback = target.getClass().getMethod(limiter.fallback(), msg.getParameterTypes());
        return fallback.invoke(target, pjp.getArgs());
    }
}

