/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.retry.aop;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.retry.annotation.GuavaRetrying;
import com.taotao.boot.retry.listener.RetryLogListener;
import com.taotao.boot.retry.strategy.SpinBlockStrategy;
import io.github.itning.retry.Attempt;
import io.github.itning.retry.Retryer;
import io.github.itning.retry.RetryerBuilder;
import io.github.itning.retry.listener.RetryListener;
import io.github.itning.retry.strategy.block.BlockStrategy;
import io.github.itning.retry.strategy.stop.StopStrategies;
import io.github.itning.retry.strategy.wait.WaitStrategies;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class GuavaRetryingAspect {
    @Around(value="@annotation(com.taotao.boot.retry.annotation.GuavaRetrying)")
    public Object monitorAround(ProceedingJoinPoint pjp) throws Throwable {
        Signature signature = pjp.getSignature();
        if (!(signature instanceof MethodSignature)) {
            return null;
        }
        MethodSignature signature2 = (MethodSignature)signature;
        Method method = signature2.getMethod();
        GuavaRetrying annotation = method.getDeclaredAnnotation(GuavaRetrying.class);
        if (annotation.duration() <= 0L && annotation.attemptNumber() <= 1) {
            return pjp.proceed();
        }
        RetryerBuilder builder = RetryerBuilder.newBuilder();
        if (annotation.attemptNumber() > 0) {
            builder.withStopStrategy(StopStrategies.stopAfterAttempt((int)annotation.attemptNumber()));
        }
        if (annotation.duration() > 0L) {
            builder.withStopStrategy(StopStrategies.stopAfterDelay((long)annotation.duration(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        if (annotation.waitStrategySleepTime() > 0L) {
            builder.withWaitStrategy(WaitStrategies.fixedWait((long)annotation.waitStrategySleepTime(), (TimeUnit)TimeUnit.SECONDS));
        }
        builder.withBlockStrategy((BlockStrategy)new SpinBlockStrategy());
        builder.withRetryListener((RetryListener)new RetryLogListener());
        for (Class<? extends Throwable> retryThrowable : annotation.exceptionClass()) {
            if (retryThrowable == null || !Throwable.class.isAssignableFrom(retryThrowable)) continue;
            builder.retryIfExceptionOfType(retryThrowable);
        }
        return builder.build().call(() -> {
            try {
                return pjp.proceed();
            }
            catch (Throwable throwable) {
                throw new Exception(throwable);
            }
        });
    }

    public void guavaRetry() {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfExceptionOfType(IOException.class).retryIfResult(res -> res == false).withWaitStrategy(WaitStrategies.exponentialWait((long)100L, (long)5L, (TimeUnit)TimeUnit.MINUTES)).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).withRetryListener(new RetryListener(this){

            public void onRetry(Attempt attempt) {
                LogUtils.info((String)"number: {}", (Object[])new Object[]{attempt.getAttemptNumber()});
            }
        }).build();
        try {
            retryer.call(() -> {
                LogUtils.info((String)"sdlf", (Object[])new Object[0]);
                return false;
            });
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
        }
    }
}

