/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.retry.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.retry.aop.GuavaRetryingAspect;
import com.taotao.boot.retry.properties.RetryProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.annotation.EnableRetry;

@EnableRetry
@AutoConfiguration
@EnableConfigurationProperties(value={RetryProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.retry", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class RetryAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(RetryAutoConfiguration.class, (String)"taotao-boot-starter-retry", (String[])new String[0]);
    }

    @Bean
    public GuavaRetryingAspect guavaRetryingAspect() {
        return new GuavaRetryingAspect();
    }
}

