/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.retry.strategy;

import com.taotao.boot.common.utils.log.LogUtils;
import io.github.itning.retry.strategy.block.BlockStrategy;
import java.time.Duration;
import java.time.LocalDateTime;

public class SpinBlockStrategy
implements BlockStrategy {
    public void block(long sleepTime) throws InterruptedException {
        long start;
        LocalDateTime startTime = LocalDateTime.now();
        long end = start = System.currentTimeMillis();
        LogUtils.info((String)"[SpinBlockStrategy]...begin wait.", (Object[])new Object[0]);
        while (end - start <= sleepTime) {
            end = System.currentTimeMillis();
        }
        Duration duration = Duration.between(startTime, LocalDateTime.now());
        LogUtils.info((String)"[SpinBlockStrategy]...end wait.duration={}", (Object[])new Object[]{duration.toMillis()});
    }
}

