/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.security.spring.authentication.login.extension.mfa.totp;

import com.taotao.boot.security.spring.authentication.login.extension.mfa.totp.MfaAuthenticationManager;
import com.taotao.boot.totp.code.CodeGenerator;
import com.taotao.boot.totp.code.CodeVerifier;
import com.taotao.boot.totp.code.DefaultCodeGenerator;
import com.taotao.boot.totp.code.DefaultCodeVerifier;
import com.taotao.boot.totp.code.HashingAlgorithm;
import com.taotao.boot.totp.exceptions.QrGenerationException;
import com.taotao.boot.totp.qr.QrData;
import com.taotao.boot.totp.qr.QrDataFactory;
import com.taotao.boot.totp.qr.QrGenerator;
import com.taotao.boot.totp.qr.ZxingPngQrGenerator;
import com.taotao.boot.totp.secret.DefaultSecretGenerator;
import com.taotao.boot.totp.secret.SecretGenerator;
import com.taotao.boot.totp.time.SystemTimeProvider;
import com.taotao.boot.totp.time.TimeProvider;
import com.taotao.boot.totp.util.Utils;

public class DefaultTotpManager
implements MfaAuthenticationManager {
    private static final int DEFAULT_SECRET_LENGTH = 64;
    private static final int DEFAULT_CODE_LENGTH = 6;
    private static final int DEFAULT_TIME_PERIOD = 30;
    private final QrDataFactory qrDataFactory = new QrDataFactory(HashingAlgorithm.SHA256, 6, 30);
    private final QrGenerator qrGenerator = new ZxingPngQrGenerator();
    private final SecretGenerator secretGenerator = new DefaultSecretGenerator(64);
    private final CodeVerifier verifier;

    public DefaultTotpManager() {
        SystemTimeProvider timeProvider = new SystemTimeProvider();
        DefaultCodeGenerator codeGenerator = new DefaultCodeGenerator(HashingAlgorithm.SHA256, 6);
        this.verifier = new DefaultCodeVerifier((CodeGenerator)codeGenerator, (TimeProvider)timeProvider);
    }

    @Override
    public String generateSecret() {
        return this.secretGenerator.generate();
    }

    @Override
    public boolean validCode(String secret, String code) {
        return this.verifier.isValidCode(secret, code);
    }

    @Override
    public String getUriForImage(String label, String secret, String issuer) throws QrGenerationException {
        QrData data = this.qrDataFactory.newBuilder().label(label).secret(secret).issuer(issuer).build();
        String qrCodeImage = Utils.getDataUriForImage((byte[])this.qrGenerator.generate(data), (String)this.qrGenerator.getImageMimeType());
        return qrCodeImage;
    }
}

