/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.security.spring.authentication.login.form.sms;

import com.taotao.boot.security.spring.authentication.login.form.sms.FormSmsLoginAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class FormSmsLoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String SPRING_SECURITY_FORM_PHONE_KEY = "phone";
    public static final String SPRING_SECURITY_FORM_CAPTCHA_KEY = "captcha";
    public static final String SPRING_SECURITY_FORM_TYPE_KEY = "type";
    private static final PathPatternRequestMatcher DEFAULT_ANT_PATH_REQUEST_MATCHER = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, "/form/login/phone");
    private String phoneParameter = "phone";
    private String captchaParameter = "captcha";
    private String typeParameter = "type";
    private Converter<HttpServletRequest, FormSmsLoginAuthenticationToken> phoneAuthenticationTokenConverter = this.defaultConverter();
    private boolean postOnly = true;

    public FormSmsLoginAuthenticationFilter() {
        super((RequestMatcher)DEFAULT_ANT_PATH_REQUEST_MATCHER);
    }

    public FormSmsLoginAuthenticationFilter(AuthenticationManager authenticationManager) {
        super((RequestMatcher)DEFAULT_ANT_PATH_REQUEST_MATCHER, authenticationManager);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !HttpMethod.POST.matches(request.getMethod())) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        FormSmsLoginAuthenticationToken authRequest = (FormSmsLoginAuthenticationToken)((Object)this.phoneAuthenticationTokenConverter.convert((Object)request));
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    private Converter<HttpServletRequest, FormSmsLoginAuthenticationToken> defaultConverter() {
        return request -> {
            String phone = request.getParameter(this.phoneParameter);
            phone = phone != null ? phone.trim() : "";
            String captcha = request.getParameter(this.captchaParameter);
            captcha = captcha != null ? captcha.trim() : "";
            String type = request.getParameter(this.typeParameter);
            type = type != null ? type.trim() : "";
            return new FormSmsLoginAuthenticationToken(phone, captcha, type);
        };
    }

    protected void setDetails(HttpServletRequest request, FormSmsLoginAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public void setPhoneParameter(String phoneParameter) {
        Assert.hasText((String)phoneParameter, (String)"phoneParameter must not be empty or null");
        this.phoneParameter = phoneParameter;
    }

    public void setCaptchaParameter(String captchaParameter) {
        Assert.hasText((String)captchaParameter, (String)"Password parameter must not be empty or null");
        this.captchaParameter = captchaParameter;
    }

    public void setConverter(Converter<HttpServletRequest, FormSmsLoginAuthenticationToken> converter) {
        Assert.notNull(converter, (String)"Converter must not be null");
        this.phoneAuthenticationTokenConverter = converter;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    public final String getPhoneParameter() {
        return this.phoneParameter;
    }

    public final String getCaptchaParameter() {
        return this.captchaParameter;
    }

    public String getTypeParameter() {
        return this.typeParameter;
    }

    public void setTypeParameter(String typeParameter) {
        this.typeParameter = typeParameter;
    }

    public Converter<HttpServletRequest, FormSmsLoginAuthenticationToken> getPhoneAuthenticationTokenConverter() {
        return this.phoneAuthenticationTokenConverter;
    }

    public void setPhoneAuthenticationTokenConverter(Converter<HttpServletRequest, FormSmsLoginAuthenticationToken> phoneAuthenticationTokenConverter) {
        this.phoneAuthenticationTokenConverter = phoneAuthenticationTokenConverter;
    }

    public boolean isPostOnly() {
        return this.postOnly;
    }
}

