/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.security.spring.configuration;

import com.taotao.boot.cache.redis.repository.RedisRepository;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.security.spring.oauth2.token.OAuth2AccessTokenStore;
import com.taotao.boot.security.spring.properties.OAuth2AuthenticationProperties;
import jakarta.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@EnableConfigurationProperties(value={OAuth2AuthenticationProperties.class})
public class SecurityAuthenticationAutoConfiguration {
    @PostConstruct
    public void postConstruct() {
        LogUtils.info((String)"SDK [OAuth2 Authentication] Auto Configure.", (Object[])new Object[0]);
    }

    @Configuration
    @ConditionalOnClass(value={RedisRepository.class})
    public static class OAuth2AccessTokenStoreConfiguration {
        @Bean
        @ConditionalOnBean(value={RedisRepository.class})
        public OAuth2AccessTokenStore oAuth2AccessTokenStore(RedisRepository redisRepository) {
            return new OAuth2AccessTokenStore(redisRepository);
        }
    }
}

