/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.desensitize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.taotao.boot.common.holder.UserContextHolder;
import com.taotao.boot.common.model.BaseSecurityUser;
import com.taotao.boot.sensitive.desensitize.DesensitizeProperties;
import com.taotao.boot.sensitive.desensitize.Sensitive;
import com.taotao.boot.sensitive.desensitize.enums.SensitiveStrategy;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer,
ApplicationContextAware {
    private SensitiveStrategy strategy;
    private DesensitizeProperties desensitizeProperties;

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeString(this.strategy.desensitizer().apply(value));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        Sensitive annotation;
        if (this.desensitization() && Objects.nonNull(annotation = (Sensitive)property.getAnnotation(Sensitive.class)) && Objects.equals(String.class, property.getType().getRawClass())) {
            this.strategy = annotation.strategy();
            return this;
        }
        return prov.findValueSerializer(property.getType(), property);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.desensitizeProperties = (DesensitizeProperties)applicationContext.getBean(DesensitizeProperties.class);
    }

    private boolean desensitization() {
        BaseSecurityUser baseSecurityUser = UserContextHolder.getUser();
        if (baseSecurityUser == null) {
            return true;
        }
        if (baseSecurityUser.getType() == 2) {
            return this.desensitizeProperties.getSensitiveLevel() == 2;
        }
        if (baseSecurityUser.getType() == 1) {
            return this.desensitizeProperties.getSensitiveLevel() >= 1;
        }
        return false;
    }
}

