/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivejson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.taotao.boot.common.utils.bean.BeanUtils;
import com.taotao.boot.sensitive.sensitivejson.Condition;
import com.taotao.boot.sensitive.sensitivejson.Sensitive;
import com.taotao.boot.sensitive.sensitivejson.SensitiveStrategy;
import java.io.IOException;
import java.util.Objects;

public class SensitiveJsonSerializer
extends JsonSerializer<String>
implements ContextualSerializer {
    private SensitiveStrategy strategy;
    private Condition condition;

    public void serialize(String value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.condition.valid()) {
            jsonGenerator.writeString(this.strategy.getDesensitizer().apply(value));
        } else {
            jsonGenerator.writeString(value);
        }
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Sensitive sensitive = (Sensitive)beanProperty.getAnnotation(Sensitive.class);
        if (Objects.nonNull(sensitive) && Objects.equals(String.class, beanProperty.getType().getRawClass())) {
            this.strategy = sensitive.value();
            this.condition = (Condition)BeanUtils.newInstance(sensitive.condition());
            return this;
        }
        return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
    }
}

