/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivejson;

import java.lang.reflect.Method;
import java.util.Map;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public final class SpringElUtil {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final ParserContext parserContext = new TemplateParserContext();
    private static final BeanResolver beanResolver = new BeanFactoryResolver((BeanFactory)SpringUtil.getBeanFactory());

    private SpringElUtil() {
    }

    public static <T> T parse(String el, StandardEvaluationContext context, Class<T> type) {
        context.setBeanResolver(beanResolver);
        if (CharSequenceUtil.startWith((CharSequence)el, (CharSequence)parserContext.getExpressionPrefix()) && CharSequenceUtil.endWith((CharSequence)el, (CharSequence)parserContext.getExpressionSuffix())) {
            return (T)parser.parseExpression(el, parserContext).getValue((EvaluationContext)context, type);
        }
        return (T)parser.parseExpression(el).getValue((EvaluationContext)context, type);
    }

    public static StandardEvaluationContext getStandardEvaluationContext(String name, Object value) {
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        standardEvaluationContext.setVariable(name, value);
        return standardEvaluationContext;
    }

    public static StandardEvaluationContext getStandardEvaluationContext(Map<String, Object> variable) {
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        standardEvaluationContext.setVariables(variable);
        return standardEvaluationContext;
    }

    public static MethodBasedEvaluationContext getMethodBasedEvaluationContext(Method method, Object[] args) {
        return new MethodBasedEvaluationContext(null, method, args, (ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
    }
}

