/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivelog.core.api;

import com.alibaba.fastjson2.JSON;
import com.taotao.boot.common.support.deepcopy.IDeepCopy;
import com.taotao.boot.common.utils.collection.ArrayUtils;
import com.taotao.boot.common.utils.collection.CollectionUtils;
import com.taotao.boot.common.utils.lang.ObjectUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ClassTypeUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.sensitive.sensitivelog.annotation.Sensitive;
import com.taotao.boot.sensitive.sensitivelog.annotation.metadata.SensitiveCondition;
import com.taotao.boot.sensitive.sensitivelog.annotation.metadata.SensitiveStrategy;
import com.taotao.boot.sensitive.sensitivelog.api.ICondition;
import com.taotao.boot.sensitive.sensitivelog.api.ISensitive;
import com.taotao.boot.sensitive.sensitivelog.api.ISensitiveConfig;
import com.taotao.boot.sensitive.sensitivelog.api.IStrategy;
import com.taotao.boot.sensitive.sensitivelog.api.impl.SensitiveStrategyBuiltIn;
import com.taotao.boot.sensitive.sensitivelog.core.api.context.SensitiveContext;
import com.taotao.boot.sensitive.sensitivelog.core.exception.SensitiveRuntimeException;
import com.taotao.boot.sensitive.sensitivelog.core.util.entry.SensitiveEntryUtil;
import com.taotao.boot.sensitive.sensitivelog.core.util.strategy.SensitiveStrategyBuiltInUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SensitiveService<T>
implements ISensitive<T> {
    @Override
    public T desCopy(T object, ISensitiveConfig config) {
        Class<?> clazz = object.getClass();
        SensitiveContext context = new SensitiveContext();
        IDeepCopy deepCopy = config.deepCopy();
        Object copyObject = deepCopy.deepCopy(object);
        this.handleClassField(context, copyObject, clazz);
        return (T)copyObject;
    }

    @Override
    public String desJson(T object, ISensitiveConfig config) {
        if (ObjectUtils.isNull(object)) {
            return JSON.toJSONString(object);
        }
        SensitiveContext context = new SensitiveContext();
        return JSON.toJSONString(object);
    }

    private void handleClassField(SensitiveContext context, Object copyObject, Class clazz) {
        Field[] fieldList = clazz.getFields();
        context.setAllFieldList(List.of(fieldList));
        context.setCurrentObject(copyObject);
        try {
            for (Field field : fieldList) {
                Class<?> fieldTypeClass = field.getType();
                context.setCurrentField(field);
                if (SensitiveEntryUtil.hasSensitiveEntry(field)) {
                    if (ClassTypeUtils.isJavaBean(fieldTypeClass)) {
                        Object fieldNewObject = field.get(copyObject);
                        this.handleClassField(context, fieldNewObject, fieldTypeClass);
                        continue;
                    }
                    if (ClassTypeUtils.isArray(fieldTypeClass)) {
                        Object[] arrays = (Object[])field.get(copyObject);
                        if (!ArrayUtils.isNotEmpty((Object[])arrays)) continue;
                        Object firstArrayEntry = arrays[0];
                        Class<?> entryFieldClass = firstArrayEntry.getClass();
                        if (this.needHandleEntryType(entryFieldClass)) {
                            for (Object arrayEntry : arrays) {
                                this.handleClassField(context, arrayEntry, entryFieldClass);
                            }
                            continue;
                        }
                        int arrayLength = arrays.length;
                        Object newArray = Array.newInstance(entryFieldClass, arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            Object entry = arrays[i];
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            Array.set(newArray, i, result);
                        }
                        field.set(copyObject, newArray);
                        continue;
                    }
                    if (ClassTypeUtils.isCollection(fieldTypeClass)) {
                        Collection entryCollection = (Collection)field.get(copyObject);
                        if (!CollectionUtils.isNotEmpty((Collection)entryCollection)) continue;
                        Object firstCollectionEntry = entryCollection.iterator().next();
                        Class<?> collectionEntryClass = firstCollectionEntry.getClass();
                        if (this.needHandleEntryType(collectionEntryClass)) {
                            for (Object collectionEntry : entryCollection) {
                                this.handleClassField(context, collectionEntry, collectionEntryClass);
                            }
                            continue;
                        }
                        ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
                        for (Object entry : entryCollection) {
                            Object result = this.handleSensitiveEntry(context, entry, field);
                            newResultList.add(result);
                        }
                        field.set(copyObject, newResultList);
                        continue;
                    }
                    this.handleSensitive(context, copyObject, field);
                    continue;
                }
                this.handleSensitive(context, copyObject, field);
            }
        }
        catch (IllegalAccessException e) {
            throw new SensitiveRuntimeException(e);
        }
    }

    private Object handleSensitiveEntry(SensitiveContext context, Object entry, Field field) {
        try {
            IStrategy strategy;
            Class<? extends ICondition> conditionClass;
            ICondition condition;
            Sensitive sensitive = field.getAnnotation(Sensitive.class);
            if (ObjectUtils.isNotNull((Object)sensitive) && (condition = (conditionClass = sensitive.condition()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).valid(context)) {
                Class<? extends IStrategy> strategyClass = sensitive.strategy();
                IStrategy strategy2 = strategyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return strategy2.des(entry, context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayUtils.isNotEmpty((Object[])annotations) && (ObjectUtils.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid(context)) && ObjectUtils.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                return strategy.des(entry, context);
            }
            return entry;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SensitiveRuntimeException(e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            LogUtils.error((Throwable)e);
            throw new SensitiveRuntimeException("");
        }
    }

    private void handleSensitive(SensitiveContext context, Object copyObject, Field field) {
        try {
            IStrategy strategy;
            Object[] annotations;
            Class<? extends ICondition> conditionClass;
            ICondition condition;
            Sensitive sensitive = field.getAnnotation(Sensitive.class);
            if (sensitive != null && (condition = (conditionClass = sensitive.condition()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).valid(context)) {
                Class<? extends IStrategy> strategyClass = sensitive.strategy();
                IStrategy strategy2 = strategyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy2.des(originalFieldVal, context);
                field.set(copyObject, result);
            }
            if (ArrayUtils.isNotEmpty((Object[])(annotations = field.getAnnotations())) && (ObjectUtils.isNull((Object)(condition = this.getCondition((Annotation[])annotations))) || condition.valid(context)) && ObjectUtils.isNotNull((Object)(strategy = this.getStrategy((Annotation[])annotations)))) {
                Object originalFieldVal = field.get(copyObject);
                Object result = strategy.des(originalFieldVal, context);
                field.set(copyObject, result);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SensitiveRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            LogUtils.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LogUtils.error((Throwable)e);
        }
    }

    private IStrategy getStrategy(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            SensitiveStrategy sensitiveStrategy = annotation.annotationType().getAnnotation(SensitiveStrategy.class);
            if (!ObjectUtils.isNotNull((Object)sensitiveStrategy)) continue;
            Class<? extends IStrategy> clazz = sensitiveStrategy.value();
            if (SensitiveStrategyBuiltIn.class.equals(clazz)) {
                return SensitiveStrategyBuiltInUtil.require(annotation.annotationType());
            }
            return (IStrategy)ClassUtils.newInstance(clazz);
        }
        return null;
    }

    private ICondition getCondition(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            SensitiveCondition sensitiveCondition = annotation.annotationType().getAnnotation(SensitiveCondition.class);
            if (!ObjectUtils.isNotNull((Object)sensitiveCondition)) continue;
            Class<? extends ICondition> customClass = sensitiveCondition.value();
            return (ICondition)ClassUtils.newInstance(customClass);
        }
        return null;
    }

    private boolean needHandleEntryType(Class fieldTypeClass) {
        if (ClassTypeUtils.isBase((Class)fieldTypeClass) || ClassTypeUtils.isMap((Class)fieldTypeClass)) {
            return false;
        }
        return ClassTypeUtils.isJavaBean((Class)fieldTypeClass) || ClassTypeUtils.isArray((Class)fieldTypeClass) || ClassTypeUtils.isCollection((Class)fieldTypeClass);
    }
}

