/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivelog.core.util.strategy;

import com.taotao.boot.common.utils.lang.ObjectUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.sensitive.sensitivelog.annotation.metadata.SensitiveStrategy;
import com.taotao.boot.sensitive.sensitivelog.annotation.strategy.SensitiveStrategyCardId;
import com.taotao.boot.sensitive.sensitivelog.annotation.strategy.SensitiveStrategyChineseName;
import com.taotao.boot.sensitive.sensitivelog.annotation.strategy.SensitiveStrategyEmail;
import com.taotao.boot.sensitive.sensitivelog.annotation.strategy.SensitiveStrategyPassword;
import com.taotao.boot.sensitive.sensitivelog.annotation.strategy.SensitiveStrategyPhone;
import com.taotao.boot.sensitive.sensitivelog.api.IStrategy;
import com.taotao.boot.sensitive.sensitivelog.api.impl.SensitiveStrategyBuiltIn;
import com.taotao.boot.sensitive.sensitivelog.core.api.strategory.StrategyCardId;
import com.taotao.boot.sensitive.sensitivelog.core.api.strategory.StrategyChineseName;
import com.taotao.boot.sensitive.sensitivelog.core.api.strategory.StrategyEmail;
import com.taotao.boot.sensitive.sensitivelog.core.api.strategory.StrategyPassword;
import com.taotao.boot.sensitive.sensitivelog.core.api.strategory.StrategyPhone;
import com.taotao.boot.sensitive.sensitivelog.core.exception.SensitiveRuntimeException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class SensitiveStrategyBuiltInUtil {
    private static final Map<Class<? extends Annotation>, IStrategy> MAP = new HashMap<Class<? extends Annotation>, IStrategy>();

    private SensitiveStrategyBuiltInUtil() {
    }

    public static IStrategy require(Class<? extends Annotation> annotationClass) {
        IStrategy strategy = MAP.get(annotationClass);
        if (ObjectUtils.isNull((Object)strategy)) {
            throw new SensitiveRuntimeException("\u4e0d\u652f\u6301\u7684\u7cfb\u7edf\u5185\u7f6e\u65b9\u6cd5\uff0c\u7528\u6237\u8bf7\u52ff\u5728\u81ea\u5b9a\u4e49\u6ce8\u89e3\u4e2d\u4f7f\u7528[SensitiveStrategyBuiltIn]!");
        }
        return strategy;
    }

    public static Optional<IStrategy> getStrategyOpt(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            SensitiveStrategy sensitiveStrategy = annotation.annotationType().getAnnotation(SensitiveStrategy.class);
            if (!ObjectUtils.isNotNull((Object)sensitiveStrategy)) continue;
            Class<? extends IStrategy> clazz = sensitiveStrategy.value();
            IStrategy strategy = null;
            strategy = SensitiveStrategyBuiltIn.class.equals(clazz) ? SensitiveStrategyBuiltInUtil.require(annotation.annotationType()) : (IStrategy)ClassUtils.newInstance(clazz);
            return Optional.ofNullable(strategy);
        }
        return Optional.empty();
    }

    static {
        MAP.put(SensitiveStrategyCardId.class, new StrategyCardId());
        MAP.put(SensitiveStrategyPassword.class, new StrategyPassword());
        MAP.put(SensitiveStrategyPhone.class, new StrategyPhone());
        MAP.put(SensitiveStrategyChineseName.class, new StrategyChineseName());
        MAP.put(SensitiveStrategyEmail.class, new StrategyEmail());
    }
}

