/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivemvc;

import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.support.config.FastJsonConfig;
import com.alibaba.fastjson2.support.spring6.http.converter.FastJsonHttpMessageConverter;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sensitive.sensitivemvc.serializer.FastJsonSensitiveValueFilter;
import org.dromara.hutool.core.array.ArrayUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class FastJsonBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof FastJsonHttpMessageConverter) {
            FastJsonHttpMessageConverter fastJsonConverter = (FastJsonHttpMessageConverter)bean;
            FastJsonConfig fastJsonConfig = fastJsonConverter.getFastJsonConfig();
            Filter[] oldReadFilters = fastJsonConfig.getReaderFilters();
            Filter[] oldWriterFilters = fastJsonConfig.getWriterFilters();
            Filter[] injectFilters = new Filter[]{new FastJsonSensitiveValueFilter()};
            Filter[] newReadFilters = (Filter[])ArrayUtil.addAll((Object[][])new Filter[][]{oldReadFilters, injectFilters});
            Filter[] newWriterFilters = (Filter[])ArrayUtil.addAll((Object[][])new Filter[][]{oldWriterFilters, injectFilters});
            fastJsonConfig.setReaderFilters(newReadFilters);
            fastJsonConfig.setWriterFilters(newWriterFilters);
            LogUtils.info((String)"Injected [{}] WriterFilter to [{}]", (Object[])new Object[]{FastJsonSensitiveValueFilter.class.getName(), FastJsonHttpMessageConverter.class.getName()});
            return fastJsonConverter;
        }
        return bean;
    }
}

