/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivemvc;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sensitive.sensitivemvc.CustomizeSensitiveHandler;
import com.taotao.boot.sensitive.sensitivemvc.SensitiveWrapper;
import com.taotao.boot.sensitive.sensitivemvc.annocation.SensitiveFilterWords;
import com.taotao.boot.sensitive.sensitivemvc.annocation.SensitiveHandler;
import com.taotao.boot.sensitive.sensitivemvc.annocation.SensitiveKeepLength;
import com.taotao.boot.sensitive.sensitivemvc.util.SensitiveUtils;
import java.lang.reflect.Field;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.text.CharSequenceUtil;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public enum SensitiveStrategy {
    CHINESE_NAME{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.chineseName(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    ID_CARD{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.idCardNum(wrapper.getFieldValue(), 1, 2, wrapper.getReplacer());
        }
    }
    ,
    FIXED_PHONE{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.fixedPhone(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    MOBILE_PHONE{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.mobilePhone(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    ADDRESS{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.address(wrapper.getFieldValue(), 8, wrapper.getReplacer());
        }
    }
    ,
    EMAIL{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.email(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    PASSWORD{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.password(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    CAR_LICENSE{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.carLicense(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    BANK_CARD{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            return SensitiveUtils.bankCard(wrapper.getFieldValue(), wrapper.getReplacer());
        }
    }
    ,
    CUSTOMIZE_FILTER_WORDS{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            String fieldValue = wrapper.getFieldValue();
            String fieldName = wrapper.getFieldName();
            Object object = wrapper.getObject();
            Field field = FieldUtil.getField(object.getClass(), (String)fieldName);
            SensitiveFilterWords filterWords = field.getAnnotation(SensitiveFilterWords.class);
            if (ObjectUtils.isEmpty((Object)filterWords)) {
                LogUtils.warn((String)"{} is marked CUSTOMIZE_FILTER_WORDS strategy, but not has @SensitiveFilterWords, will ignore sensitive it.", (Object[])new Object[]{field.getName()});
                return fieldValue;
            }
            char replacer = wrapper.getReplacer();
            Object[] words = filterWords.value();
            if (!ObjectUtils.isEmpty((Object[])words)) {
                for (Object filterWord : words) {
                    if (!fieldValue.contains((CharSequence)filterWord)) continue;
                    String replacers = CharSequenceUtil.repeat((char)replacer, (int)((String)filterWord).length());
                    fieldValue = fieldValue.replace((CharSequence)filterWord, replacers);
                }
            }
            return fieldValue;
        }
    }
    ,
    CUSTOMIZE_KEEP_LENGTH{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            boolean ignoreSuffixKeep;
            String fieldValue = wrapper.getFieldValue();
            String fieldName = wrapper.getFieldName();
            Object object = wrapper.getObject();
            Field field = FieldUtil.getField(object.getClass(), (String)fieldName);
            SensitiveKeepLength sensitiveKeepLength = field.getAnnotation(SensitiveKeepLength.class);
            int preKeep = sensitiveKeepLength.preKeep();
            int postKeep = sensitiveKeepLength.postKeep();
            Assert.isTrue((preKeep >= -1 ? 1 : 0) != 0, (String)"preKeep must greater than -1");
            Assert.isTrue((postKeep >= -1 ? 1 : 0) != 0, (String)"postKeep must greater than -1");
            boolean ignorePreKeep = preKeep <= 0;
            boolean bl = ignoreSuffixKeep = postKeep <= 0;
            if (ignorePreKeep && ignoreSuffixKeep) {
                return fieldValue;
            }
            char replacer = wrapper.getReplacer();
            return CharSequenceUtil.replaceByCodePoint((CharSequence)fieldValue, (int)preKeep, (int)(fieldValue.length() - postKeep), (char)replacer);
        }
    }
    ,
    CUSTOMIZE_HANDLER{

        @Override
        public String apply(SensitiveWrapper wrapper) {
            String fieldName = wrapper.getFieldName();
            Object object = wrapper.getObject();
            Field field = FieldUtil.getField(object.getClass(), (String)fieldName);
            SensitiveHandler customizeHandler = field.getAnnotation(SensitiveHandler.class);
            Class<? extends CustomizeSensitiveHandler> handlerClass = customizeHandler.value();
            CustomizeSensitiveHandler handler = (CustomizeSensitiveHandler)ConstructorUtil.newInstance(handlerClass, (Object[])new Object[0]);
            return handler.customize(wrapper);
        }
    };


    public abstract String apply(SensitiveWrapper var1);
}

