/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivemvc.serializer;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sensitive.sensitivemvc.SensitiveStrategy;
import com.taotao.boot.sensitive.sensitivemvc.SensitiveWrapper;
import com.taotao.boot.sensitive.sensitivemvc.annocation.IgnoreSensitive;
import com.taotao.boot.sensitive.sensitivemvc.annocation.Sensitive;
import com.taotao.boot.sensitive.sensitivemvc.resolve.HandlerMethodResolver;
import com.taotao.boot.sensitive.sensitivemvc.util.AnnotationUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractFastJsonSensitiveValueFilter {
    protected Object process(Object object, String fieldName, Object fieldValue) {
        if (ObjectUtils.isEmpty((Object)fieldValue) || !String.class.isAssignableFrom(fieldValue.getClass())) {
            return fieldValue;
        }
        HandlerMethodResolver methodResolver = (HandlerMethodResolver)SpringUtil.getBean(HandlerMethodResolver.class, (Object[])new Object[0]);
        HandlerMethod handlerMethod = methodResolver.resolve();
        if (Objects.isNull(handlerMethod)) {
            return fieldValue;
        }
        IgnoreSensitive ignoreSensitive = AnnotationUtils.getAnnotation(handlerMethod, IgnoreSensitive.class);
        Optional<IgnoreSensitive> ignSensitiveOpt = Optional.ofNullable(ignoreSensitive);
        Optional<String[]> ignFieldNamesOpt = ignSensitiveOpt.map(IgnoreSensitive::value);
        if (ignSensitiveOpt.isPresent() && !ignFieldNamesOpt.filter(ArrayUtil::isNotEmpty).isPresent() || ignFieldNamesOpt.filter(names -> Arrays.asList(names).contains(fieldName)).isPresent()) {
            LogUtils.debug((String)"Skip sensitive for {}, because @IgnoreSensitive is null or not contains it.", (Object[])new Object[]{fieldName});
            return fieldValue;
        }
        Field field = FieldUtil.getField(object.getClass(), (String)fieldName);
        Sensitive sensitive = field.getAnnotation(Sensitive.class);
        if (Objects.isNull(sensitive)) {
            return fieldValue;
        }
        SensitiveStrategy strategy = sensitive.strategy();
        LogUtils.debug((String)"Sensitive for {} with {} strategy, replacer={}", (Object[])new Object[]{fieldName, strategy.name(), Character.valueOf(sensitive.replacer())});
        return strategy.apply(new SensitiveWrapper(object, fieldName, (String)fieldValue, sensitive.replacer()));
    }
}

