/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivemvc.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.sensitive.sensitivemvc.SensitiveStrategy;
import com.taotao.boot.sensitive.sensitivemvc.SensitiveWrapper;
import com.taotao.boot.sensitive.sensitivemvc.annocation.IgnoreSensitive;
import com.taotao.boot.sensitive.sensitivemvc.annocation.Sensitive;
import com.taotao.boot.sensitive.sensitivemvc.resolve.HandlerMethodResolver;
import com.taotao.boot.sensitive.sensitivemvc.util.AnnotationUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.extra.spring.SpringUtil;
import org.springframework.util.ObjectUtils;
import org.springframework.web.method.HandlerMethod;

public class JacksonSensitiveSerializer
extends JsonSerializer<String> {
    public Class<String> handledType() {
        return String.class;
    }

    public void serialize(String fieldValue, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
        if (Objects.isNull(fieldValue)) {
            gen.writeNull();
            return;
        }
        HandlerMethodResolver handlerMethodResolver = (HandlerMethodResolver)SpringUtil.getBean(HandlerMethodResolver.class, (Object[])new Object[0]);
        HandlerMethod handlerMethod = handlerMethodResolver.resolve();
        if (ObjectUtils.isEmpty((Object)handlerMethod)) {
            gen.writeString(fieldValue);
            return;
        }
        String fieldName = gen.getOutputContext().getCurrentName();
        IgnoreSensitive ignSensitive = AnnotationUtils.getAnnotation(handlerMethod, IgnoreSensitive.class);
        Optional<IgnoreSensitive> ignSensitiveOpt = Optional.ofNullable(ignSensitive);
        Optional<String[]> ignFieldNamesOpt = ignSensitiveOpt.map(IgnoreSensitive::value);
        if (ignSensitiveOpt.isPresent() && !ignFieldNamesOpt.filter(ArrayUtil::isNotEmpty).isPresent() || ignFieldNamesOpt.filter(names -> Arrays.asList(names).contains(fieldName)).isPresent()) {
            gen.writeString(fieldValue);
            LogUtils.debug((String)"Skip sensitive for {}, because @IgnoreSensitive is null or not contains it.", (Object[])new Object[]{fieldName});
            return;
        }
        Object object = gen.currentValue();
        Field field = FieldUtil.getField(object.getClass(), (String)fieldName);
        Sensitive sensitive = field.getAnnotation(Sensitive.class);
        if (Objects.isNull(sensitive)) {
            gen.writeString(fieldValue);
            return;
        }
        SensitiveStrategy strategy = sensitive.strategy();
        String finalValue = strategy.apply(new SensitiveWrapper(object, fieldName, fieldValue, sensitive.replacer()));
        LogUtils.debug((String)"Sensitive for {} with {} strategy, replacer={}", (Object[])new Object[]{fieldName, strategy.name(), Character.valueOf(sensitive.replacer())});
        gen.writeString(finalValue);
    }
}

