/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitivemvc.util;

import org.dromara.hutool.core.text.CharSequenceUtil;
import org.springframework.util.StringUtils;

public class SensitiveUtils {
    public static String chineseName(String fullName, char replacer) {
        if (!StringUtils.hasLength((String)fullName)) {
            return "";
        }
        return CharSequenceUtil.replaceByCodePoint((CharSequence)fullName, (int)1, (int)fullName.length(), (char)replacer);
    }

    public static String idCardNum(String idCardNum, int front, int end, char replacer) {
        if (!StringUtils.hasLength((String)idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return CharSequenceUtil.replaceByCodePoint((CharSequence)idCardNum, (int)front, (int)(idCardNum.length() - end), (char)replacer);
    }

    public static String fixedPhone(String num, char replacer) {
        if (!StringUtils.hasLength((String)num)) {
            return "";
        }
        return CharSequenceUtil.replaceByCodePoint((CharSequence)num, (int)4, (int)(num.length() - 2), (char)replacer);
    }

    public static String mobilePhone(String num, char replacer) {
        if (!StringUtils.hasLength((String)num)) {
            return "";
        }
        return CharSequenceUtil.replaceByCodePoint((CharSequence)num, (int)3, (int)(num.length() - 4), (char)replacer);
    }

    public static String address(String address, int sensitiveSize, char replacer) {
        if (!StringUtils.hasLength((String)address)) {
            return "";
        }
        int length = address.length();
        return CharSequenceUtil.replaceByCodePoint((CharSequence)address, (int)(length - sensitiveSize), (int)length, (char)replacer);
    }

    public static String email(String email, char replacer) {
        if (!StringUtils.hasLength((String)email)) {
            return "";
        }
        int index = CharSequenceUtil.indexOf((CharSequence)email, (char)'@');
        if (index <= 1) {
            return email;
        }
        return CharSequenceUtil.replaceByCodePoint((CharSequence)email, (int)1, (int)index, (char)replacer);
    }

    public static String password(String password, char replacer) {
        if (!StringUtils.hasLength((String)password)) {
            return "";
        }
        return CharSequenceUtil.repeat((char)replacer, (int)password.length());
    }

    public static String carLicense(String carLicense, char replacer) {
        if (!StringUtils.hasLength((String)carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)carLicense, (int)3, (int)6, (char)replacer);
        }
        if (carLicense.length() == 8) {
            return CharSequenceUtil.replaceByCodePoint((CharSequence)carLicense, (int)3, (int)7, (char)replacer);
        }
        return carLicense;
    }

    public static String bankCard(String bankCardNo, char replacer) {
        if (!StringUtils.hasLength((String)bankCardNo)) {
            return bankCardNo;
        }
        String trimBankCardNo = bankCardNo.trim();
        if (trimBankCardNo.length() < 9) {
            return trimBankCardNo;
        }
        int length = trimBankCardNo.length();
        int midLength = length - 8;
        StringBuilder buf = new StringBuilder();
        buf.append(trimBankCardNo, 0, 4);
        for (int i = 0; i < midLength; ++i) {
            if (i % 4 == 0) {
                buf.append(' ');
            }
            buf.append(replacer);
        }
        buf.append(' ').append(trimBankCardNo, length - 4, length);
        return buf.toString();
    }
}

