/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.bs;

import com.taotao.boot.common.support.handler.IHandler;
import com.taotao.boot.common.utils.collection.CollectionUtils;
import com.taotao.boot.common.utils.common.ArgUtils;
import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWord;
import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWordCharIgnore;
import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWordDestroy;
import com.taotao.boot.sensitive.sensitiveword.api.IWordAllow;
import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.api.IWordContext;
import com.taotao.boot.sensitive.sensitiveword.api.IWordData;
import com.taotao.boot.sensitive.sensitiveword.api.IWordDeny;
import com.taotao.boot.sensitive.sensitiveword.api.IWordFormat;
import com.taotao.boot.sensitive.sensitiveword.api.IWordReplace;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResult;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResultCondition;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResultHandler;
import com.taotao.boot.sensitive.sensitiveword.api.IWordTag;
import com.taotao.boot.sensitive.sensitiveword.api.combine.IWordAllowDenyCombine;
import com.taotao.boot.sensitive.sensitiveword.api.combine.IWordCheckCombine;
import com.taotao.boot.sensitive.sensitiveword.api.combine.IWordFormatCombine;
import com.taotao.boot.sensitive.sensitiveword.bs.SensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.core.SensitiveWords;
import com.taotao.boot.sensitive.sensitiveword.support.allow.WordAllows;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordChecks;
import com.taotao.boot.sensitive.sensitiveword.support.combine.allowdeny.WordAllowDenyCombines;
import com.taotao.boot.sensitive.sensitiveword.support.combine.check.WordCheckCombines;
import com.taotao.boot.sensitive.sensitiveword.support.combine.format.WordFormatCombines;
import com.taotao.boot.sensitive.sensitiveword.support.data.WordDatas;
import com.taotao.boot.sensitive.sensitiveword.support.deny.WordDenys;
import com.taotao.boot.sensitive.sensitiveword.support.ignore.SensitiveWordCharIgnores;
import com.taotao.boot.sensitive.sensitiveword.support.replace.WordReplaces;
import com.taotao.boot.sensitive.sensitiveword.support.result.WordResultHandlers;
import com.taotao.boot.sensitive.sensitiveword.support.resultcondition.WordResultConditions;
import com.taotao.boot.sensitive.sensitiveword.support.tag.WordTags;
import com.taotao.boot.sensitive.sensitiveword.utils.InnerWordFormatUtils;
import com.taotao.boot.sensitive.sensitiveword.utils.InnerWordTagUtils;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SensitiveWordBs
implements ISensitiveWordDestroy {
    private boolean ignoreCase = true;
    private boolean ignoreWidth = true;
    private boolean ignoreNumStyle = true;
    private boolean ignoreChineseStyle = true;
    private boolean ignoreEnglishStyle = true;
    private boolean ignoreRepeat = false;
    private boolean wordFailFast = true;
    private boolean enableNumCheck = false;
    private boolean enableEmailCheck = false;
    private boolean enableUrlCheck = false;
    private boolean enableWordCheck = true;
    private boolean enableIpv4Check = false;
    private int numCheckLen = 8;
    private ISensitiveWord sensitiveWord = SensitiveWords.defaults();
    private IWordData wordData = WordDatas.defaults();
    private IWordData wordDataAllow = WordDatas.defaults();
    private IWordDeny wordDeny = WordDenys.defaults();
    private IWordAllow wordAllow = WordAllows.defaults();
    private IWordReplace wordReplace = WordReplaces.defaults();
    private IWordContext context = SensitiveWordContext.newInstance();
    private IWordCheckCombine wordCheckCombine = WordCheckCombines.defaults();
    private IWordFormatCombine wordFormatCombine = WordFormatCombines.defaults();
    private IWordAllowDenyCombine wordAllowDenyCombine = WordAllowDenyCombines.defaults();
    private IWordTag wordTag = WordTags.defaults();
    private ISensitiveWordCharIgnore charIgnore = SensitiveWordCharIgnores.defaults();
    private IWordResultCondition wordResultCondition = WordResultConditions.alwaysTrue();
    private IWordCheck wordCheckWord = WordChecks.word();
    private IWordCheck wordCheckNum = WordChecks.num();
    private IWordCheck wordCheckEmail = WordChecks.email();
    private IWordCheck wordCheckUrl = WordChecks.url();
    private IWordCheck wordCheckIpv4 = WordChecks.ipv4();

    private SensitiveWordBs() {
    }

    public static SensitiveWordBs newInstance() {
        return new SensitiveWordBs();
    }

    public SensitiveWordBs init() {
        IWordContext context = this.initContext();
        IWordFormat charFormat = this.wordFormatCombine.initWordFormat(context);
        context.wordFormat(charFormat);
        IWordCheck sensitiveCheck = this.wordCheckCombine.initWordCheck(context);
        context.sensitiveCheck(sensitiveCheck);
        List<String> wordAllowList = this.wordAllow.allow();
        List<String> wordDenyList = this.wordDeny.deny();
        Collection<String> denyList = this.wordAllowDenyCombine.getActualDenyList(wordAllowList, wordDenyList, context);
        this.wordData.initWordData(denyList);
        List<String> actualAllowList = InnerWordFormatUtils.formatWordList(wordAllowList, context);
        this.wordDataAllow.initWordData(actualAllowList);
        context.wordData(this.wordData);
        context.wordDataAllow(this.wordDataAllow);
        this.context = context;
        return this;
    }

    private IWordContext initContext() {
        SensitiveWordContext context = SensitiveWordContext.newInstance();
        context.ignoreCase(this.ignoreCase);
        context.ignoreWidth(this.ignoreWidth);
        context.ignoreNumStyle(this.ignoreNumStyle);
        context.ignoreChineseStyle(this.ignoreChineseStyle);
        context.ignoreEnglishStyle(this.ignoreEnglishStyle);
        context.ignoreRepeat(this.ignoreRepeat);
        context.wordFailFast(this.wordFailFast);
        context.enableNumCheck(this.enableNumCheck);
        context.enableEmailCheck(this.enableEmailCheck);
        context.enableUrlCheck(this.enableUrlCheck);
        context.enableWordCheck(this.enableWordCheck);
        context.enableIpv4Check(this.enableIpv4Check);
        context.wordCheckWord(this.wordCheckWord);
        context.wordCheckEmail(this.wordCheckEmail);
        context.wordCheckNum(this.wordCheckNum);
        context.wordCheckUrl(this.wordCheckUrl);
        context.wordCheckIpv4(this.wordCheckIpv4);
        context.sensitiveCheckNumLen(this.numCheckLen);
        context.wordReplace(this.wordReplace);
        context.wordData(this.wordData);
        context.wordTag(this.wordTag);
        context.charIgnore(this.charIgnore);
        context.wordResultCondition(this.wordResultCondition);
        return context;
    }

    public SensitiveWordBs wordResultCondition(IWordResultCondition wordResultCondition) {
        ArgUtils.notNull((Object)wordResultCondition, (String)"wordResultCondition");
        this.wordResultCondition = wordResultCondition;
        return this;
    }

    public SensitiveWordBs charIgnore(ISensitiveWordCharIgnore charIgnore) {
        ArgUtils.notNull((Object)charIgnore, (String)"charIgnore");
        this.charIgnore = charIgnore;
        return this;
    }

    public SensitiveWordBs wordTag(IWordTag wordTag) {
        ArgUtils.notNull((Object)wordTag, (String)"wordTag");
        this.wordTag = wordTag;
        return this;
    }

    public SensitiveWordBs wordCheckCombine(IWordCheckCombine wordCheckCombine) {
        ArgUtils.notNull((Object)wordCheckCombine, (String)"wordCheckCombine");
        this.wordCheckCombine = wordCheckCombine;
        return this;
    }

    public SensitiveWordBs wordFormatCombine(IWordFormatCombine wordFormatCombine) {
        ArgUtils.notNull((Object)wordFormatCombine, (String)"wordFormatCombine");
        this.wordFormatCombine = wordFormatCombine;
        return this;
    }

    public SensitiveWordBs wordAllowDenyCombine(IWordAllowDenyCombine wordAllowDenyCombine) {
        ArgUtils.notNull((Object)wordAllowDenyCombine, (String)"wordAllowDenyCombine");
        this.wordAllowDenyCombine = wordAllowDenyCombine;
        return this;
    }

    public SensitiveWordBs wordData(IWordData wordData) {
        ArgUtils.notNull((Object)wordData, (String)"wordData");
        this.wordData = wordData;
        return this;
    }

    public SensitiveWordBs wordDataAllow(IWordData wordDataAllow) {
        ArgUtils.notNull((Object)wordDataAllow, (String)"wordDataAllow");
        this.wordDataAllow = wordDataAllow;
        return this;
    }

    public SensitiveWordBs sensitiveWord(ISensitiveWord sensitiveWord) {
        ArgUtils.notNull((Object)sensitiveWord, (String)"sensitiveWord");
        this.sensitiveWord = sensitiveWord;
        return this;
    }

    public SensitiveWordBs wordReplace(IWordReplace wordReplace) {
        ArgUtils.notNull((Object)wordReplace, (String)"wordReplace");
        this.wordReplace = wordReplace;
        return this;
    }

    public SensitiveWordBs wordDeny(IWordDeny wordDeny) {
        ArgUtils.notNull((Object)wordDeny, (String)"wordDeny");
        this.wordDeny = wordDeny;
        return this;
    }

    public SensitiveWordBs wordAllow(IWordAllow wordAllow) {
        ArgUtils.notNull((Object)wordAllow, (String)"wordAllow");
        this.wordAllow = wordAllow;
        return this;
    }

    public SensitiveWordBs wordCheckWord(IWordCheck wordCheckWord) {
        ArgUtils.notNull((Object)wordCheckWord, (String)"wordCheckWord");
        this.wordCheckWord = wordCheckWord;
        return this;
    }

    public SensitiveWordBs wordCheckNum(IWordCheck wordCheckNum) {
        ArgUtils.notNull((Object)wordCheckNum, (String)"wordCheckNum");
        this.wordCheckNum = wordCheckNum;
        return this;
    }

    public SensitiveWordBs wordCheckEmail(IWordCheck wordCheckEmail) {
        ArgUtils.notNull((Object)wordCheckEmail, (String)"wordCheckEmail");
        this.wordCheckEmail = wordCheckEmail;
        return this;
    }

    public SensitiveWordBs wordCheckUrl(IWordCheck wordCheckUrl) {
        ArgUtils.notNull((Object)wordCheckUrl, (String)"wordCheckUrl");
        this.wordCheckUrl = wordCheckUrl;
        return this;
    }

    public SensitiveWordBs wordCheckIpv4(IWordCheck wordCheckIpv4) {
        ArgUtils.notNull((Object)wordCheckIpv4, (String)"wordCheckIpv4");
        this.wordCheckIpv4 = wordCheckIpv4;
        return this;
    }

    public SensitiveWordBs enableIpv4Check(boolean enableIpv4Check) {
        this.enableIpv4Check = enableIpv4Check;
        return this;
    }

    public SensitiveWordBs enableWordCheck(boolean enableWordCheck) {
        this.enableWordCheck = enableWordCheck;
        return this;
    }

    public SensitiveWordBs enableNumCheck(boolean enableNumCheck) {
        this.enableNumCheck = enableNumCheck;
        return this;
    }

    public SensitiveWordBs numCheckLen(int numCheckLen) {
        this.numCheckLen = numCheckLen;
        return this;
    }

    public SensitiveWordBs enableEmailCheck(boolean enableEmailCheck) {
        this.enableEmailCheck = enableEmailCheck;
        return this;
    }

    public SensitiveWordBs enableUrlCheck(boolean enableUrlCheck) {
        this.enableUrlCheck = enableUrlCheck;
        return this;
    }

    public SensitiveWordBs ignoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public SensitiveWordBs ignoreWidth(boolean ignoreWidth) {
        this.ignoreWidth = ignoreWidth;
        return this;
    }

    public SensitiveWordBs ignoreNumStyle(boolean ignoreNumStyle) {
        this.ignoreNumStyle = ignoreNumStyle;
        return this;
    }

    public SensitiveWordBs ignoreChineseStyle(boolean ignoreChineseStyle) {
        this.ignoreChineseStyle = ignoreChineseStyle;
        return this;
    }

    public SensitiveWordBs ignoreEnglishStyle(boolean ignoreEnglishStyle) {
        this.ignoreEnglishStyle = ignoreEnglishStyle;
        return this;
    }

    public SensitiveWordBs ignoreRepeat(boolean ignoreRepeat) {
        this.ignoreRepeat = ignoreRepeat;
        return this;
    }

    public SensitiveWordBs wordFailFast(boolean wordFailFast) {
        this.wordFailFast = wordFailFast;
        return this;
    }

    public boolean contains(String target) {
        return this.sensitiveWord.contains(target, this.context);
    }

    public List<String> findAll(String target) {
        return this.findAll(target, WordResultHandlers.word());
    }

    public String findFirst(String target) {
        return this.findFirst(target, WordResultHandlers.word());
    }

    public <R> List<R> findAll(final String target, final IWordResultHandler<R> handler) {
        ArgUtils.notNull(handler, (String)"handler");
        List<IWordResult> wordResults = this.sensitiveWord.findAll(target, this.context);
        return CollectionUtils.toList(wordResults, (IHandler)new IHandler<IWordResult, R>(){

            public R handle(IWordResult wordResult) {
                return handler.handle(wordResult, SensitiveWordBs.this.context, target);
            }
        });
    }

    public <R> R findFirst(String target, IWordResultHandler<R> handler) {
        ArgUtils.notNull(handler, (String)"handler");
        IWordResult wordResult = this.sensitiveWord.findFirst(target, this.context);
        return handler.handle(wordResult, this.context, target);
    }

    public String replace(String target) {
        return this.sensitiveWord.replace(target, this.context);
    }

    public Set<String> tags(String word) {
        return InnerWordTagUtils.tags(word, this.context);
    }

    @Override
    public void destroy() {
        this.wordData.destroy();
        this.wordDataAllow.destroy();
    }

    public void removeWord(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.removeWord(wordList);
    }

    public void removeWord(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        List<String> formatList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordData.removeWord(formatList);
    }

    public void addWord(Collection<String> collection) {
        List<String> formatAllowList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordData.addWord(formatAllowList);
    }

    public void addWord(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.addWord(wordList);
    }

    public void removeWordAllow(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.removeWordAllow(wordList);
    }

    public void removeWordAllow(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        List<String> formatList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordDataAllow.removeWord(formatList);
    }

    public void addWordAllow(Collection<String> collection) {
        List<String> formatList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordDataAllow.addWord(formatList);
    }

    public void addWordAllow(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.addWordAllow(wordList);
    }
}

