/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.core;

import com.taotao.boot.common.utils.common.StringUtils;
import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWord;
import com.taotao.boot.sensitive.sensitiveword.api.IWordContext;
import com.taotao.boot.sensitive.sensitiveword.api.IWordReplace;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResult;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSensitiveWord
implements ISensitiveWord {
    protected abstract List<IWordResult> doFindAll(String var1, IWordContext var2);

    protected abstract IWordResult doFindFirst(String var1, IWordContext var2);

    protected String doReplace(String target, List<IWordResult> allList, IWordContext context) {
        IWordReplace replace = context.wordReplace();
        StringBuilder stringBuilder = new StringBuilder();
        int startIndex = 0;
        char[] rawChars = target.toCharArray();
        for (IWordResult wordResult : allList) {
            int itemStartIx = wordResult.startIndex();
            int itemEndIx = wordResult.endIndex();
            if (startIndex < itemStartIx) {
                stringBuilder.append(rawChars, startIndex, itemStartIx - startIndex);
            }
            replace.replace(stringBuilder, rawChars, wordResult, context);
            startIndex = Math.max(startIndex, itemEndIx);
        }
        if (startIndex < rawChars.length) {
            stringBuilder.append(rawChars, startIndex, rawChars.length - startIndex);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<IWordResult> findAll(String string, IWordContext context) {
        if (StringUtils.isEmpty((String)string)) {
            return Collections.emptyList();
        }
        return this.doFindAll(string, context);
    }

    @Override
    public IWordResult findFirst(String string, IWordContext context) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.doFindFirst(string, context);
    }

    @Override
    public String replace(String target, IWordContext context) {
        if (StringUtils.isEmpty((String)target)) {
            return target;
        }
        List<IWordResult> allList = this.findAll(target, context);
        if (CollectionUtil.isEmpty(allList)) {
            return target;
        }
        return this.doReplace(target, allList, context);
    }

    @Override
    public boolean contains(String string, IWordContext context) {
        IWordResult firstResult = this.findFirst(string, context);
        return firstResult != null;
    }
}

