/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.core;

import com.google.common.collect.Lists;
import com.taotao.boot.common.utils.collection.CollectionUtils;
import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWord;
import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.api.IWordContext;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResult;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResultCondition;
import com.taotao.boot.sensitive.sensitiveword.api.context.InnerSensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordValidModeEnum;
import com.taotao.boot.sensitive.sensitiveword.core.AbstractSensitiveWord;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckResult;
import com.taotao.boot.sensitive.sensitiveword.support.result.WordResult;
import com.taotao.boot.sensitive.sensitiveword.utils.InnerWordFormatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SensitiveWord
extends AbstractSensitiveWord {
    private static final ISensitiveWord INSTANCE = new SensitiveWord();

    public static ISensitiveWord getInstance() {
        return INSTANCE;
    }

    @Override
    protected List<IWordResult> doFindAll(String string, IWordContext context) {
        return this.innerSensitiveWords(string, WordValidModeEnum.FAIL_OVER, context);
    }

    @Override
    protected IWordResult doFindFirst(String string, IWordContext context) {
        List<IWordResult> wordResults = this.innerSensitiveWords(string, WordValidModeEnum.FAIL_FAST, context);
        if (!CollectionUtils.isEmpty(wordResults)) {
            return wordResults.get(0);
        }
        return null;
    }

    private List<IWordResult> innerSensitiveWords(String text, WordValidModeEnum modeEnum, IWordContext context) {
        IWordCheck sensitiveCheck = context.sensitiveCheck();
        ArrayList resultList = Lists.newArrayList();
        Map<Character, Character> characterCharacterMap = InnerWordFormatUtils.formatCharsMapping(text, context);
        InnerSensitiveWordContext checkContext = InnerSensitiveWordContext.newInstance().originalText(text).wordContext(context).modeEnum(WordValidModeEnum.FAIL_OVER).formatCharMapping(characterCharacterMap);
        IWordResultCondition wordResultCondition = context.wordResultCondition();
        for (int i = 0; i < text.length(); ++i) {
            int wordLengthDeny;
            WordCheckResult checkResult = sensitiveCheck.sensitiveCheck(i, checkContext);
            int wordLengthAllow = checkResult.wordLengthResult().wordAllowLen();
            if (wordLengthAllow < (wordLengthDeny = checkResult.wordLengthResult().wordDenyLen())) {
                WordResult wordResult = WordResult.newInstance().startIndex(i).endIndex(i + wordLengthDeny).type(checkResult.type()).word(checkResult.wordLengthResult().wordDeny());
                if (wordResultCondition.match(wordResult, text, modeEnum, context)) {
                    resultList.add(wordResult);
                    if (WordValidModeEnum.FAIL_FAST.equals((Object)modeEnum)) break;
                }
                i += wordLengthDeny - 1;
                continue;
            }
            i += Math.max(0, wordLengthAllow - 1);
        }
        return resultList;
    }
}

