/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.core;

import com.taotao.boot.sensitive.sensitiveword.api.IWordReplace;
import com.taotao.boot.sensitive.sensitiveword.api.IWordResultHandler;
import com.taotao.boot.sensitive.sensitiveword.bs.SensitiveWordBs;
import com.taotao.boot.sensitive.sensitiveword.support.replace.WordReplaces;
import java.util.List;

public final class SensitiveWordHelper {
    private static final SensitiveWordBs WORD_BS = SensitiveWordBs.newInstance().enableNumCheck(false).enableEmailCheck(false).enableUrlCheck(false).init();

    private SensitiveWordHelper() {
    }

    public static boolean contains(String target) {
        return WORD_BS.contains(target);
    }

    public static List<String> findAll(String target) {
        return WORD_BS.findAll(target);
    }

    public static String findFirst(String target) {
        return WORD_BS.findFirst(target);
    }

    public static String replace(String target, IWordReplace replace) {
        SensitiveWordBs sensitiveWordBs = SensitiveWordBs.newInstance().wordReplace(replace).init();
        return sensitiveWordBs.replace(target);
    }

    public static String replace(String target, char replaceChar) {
        IWordReplace replace = WordReplaces.chars(replaceChar);
        return SensitiveWordHelper.replace(target, replace);
    }

    public static String replace(String target) {
        return WORD_BS.replace(target);
    }

    public static <R> List<R> findAll(String target, IWordResultHandler<R> handler) {
        return WORD_BS.findAll(target, handler);
    }

    public static <R> R findFirst(String target, IWordResultHandler<R> handler) {
        return WORD_BS.findFirst(target, handler);
    }
}

