/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.check;

import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWordCharIgnore;
import com.taotao.boot.sensitive.sensitiveword.api.IWordContext;
import com.taotao.boot.sensitive.sensitiveword.api.context.InnerSensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.support.check.AbstractWordCheck;
import com.taotao.boot.sensitive.sensitiveword.support.result.WordLengthResult;
import java.util.Map;

public abstract class AbstractConditionWordCheck
extends AbstractWordCheck {
    protected abstract boolean isCharCondition(char var1, int var2, InnerSensitiveWordContext var3);

    protected abstract boolean isStringCondition(int var1, StringBuilder var2, InnerSensitiveWordContext var3);

    @Override
    protected WordLengthResult getActualLength(int beginIndex, InnerSensitiveWordContext checkContext) {
        ISensitiveWordCharIgnore charIgnore = checkContext.wordContext().charIgnore();
        String txt = checkContext.originalText();
        char[] chars = txt.toCharArray();
        IWordContext context = checkContext.wordContext();
        Map<Character, Character> formatCharMapping = checkContext.formatCharMapping();
        int actualLength = 0;
        int tempIgnoreLen = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int currentIx = 0;
        for (int i = beginIndex; i < txt.length(); ++i) {
            currentIx = i;
            boolean ignoreCharFlag = charIgnore.ignore(currentIx, chars, checkContext);
            if (ignoreCharFlag) {
                ++tempIgnoreLen;
                continue;
            }
            char currentChar = txt.charAt(i);
            char mappingChar = formatCharMapping.get(Character.valueOf(currentChar)).charValue();
            boolean currentCondition = this.isCharCondition(mappingChar, i, checkContext);
            if (!currentCondition) break;
            stringBuilder.append(currentChar);
        }
        if (this.isStringCondition(currentIx, stringBuilder, checkContext)) {
            actualLength = stringBuilder.length();
            actualLength += tempIgnoreLen;
        }
        tempIgnoreLen = 0;
        return WordLengthResult.newInstance().wordDenyLen(actualLength).wordAllowLen(0);
    }
}

