/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.check;

import com.taotao.boot.common.utils.common.CharUtils;
import com.taotao.boot.common.utils.common.RegexUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.api.context.InnerSensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordTypeEnum;
import com.taotao.boot.sensitive.sensitiveword.support.check.AbstractConditionWordCheck;

public class WordCheckEmail
extends AbstractConditionWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckEmail();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckEmail.class;
    }

    @Override
    protected String getType() {
        return WordTypeEnum.EMAIL.getCode();
    }

    @Override
    protected boolean isCharCondition(char mappingChar, int index, InnerSensitiveWordContext checkContext) {
        return CharUtils.isEmilChar((char)mappingChar);
    }

    @Override
    protected boolean isStringCondition(int index, StringBuilder stringBuilder, InnerSensitiveWordContext checkContext) {
        int bufferLen = stringBuilder.length();
        if (bufferLen < 6) {
            return false;
        }
        if (bufferLen > 64) {
            return false;
        }
        String string = stringBuilder.toString();
        return RegexUtils.isEmail((String)string);
    }
}

