/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.check;

import com.taotao.boot.common.utils.common.CharUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.api.context.InnerSensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordTypeEnum;
import com.taotao.boot.sensitive.sensitiveword.support.check.AbstractConditionWordCheck;
import com.taotao.boot.sensitive.sensitiveword.utils.InnerCharUtils;
import java.util.List;

public class WordCheckIPV4
extends AbstractConditionWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckIPV4();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckIPV4.class;
    }

    @Override
    protected String getType() {
        return WordTypeEnum.IPV4.getCode();
    }

    @Override
    protected boolean isCharCondition(char mappingChar, int index, InnerSensitiveWordContext checkContext) {
        return CharUtils.isNumber((char)mappingChar) || '.' == mappingChar;
    }

    @Override
    protected boolean isStringCondition(int index, StringBuilder stringBuilder, InnerSensitiveWordContext checkContext) {
        int bufferLen = stringBuilder.length();
        if (bufferLen < 7 || bufferLen > 15) {
            return false;
        }
        String string = stringBuilder.toString();
        List stringList = StringUtils.splitToList((String)string, (String)".");
        if (stringList.size() != 4) {
            return false;
        }
        for (String numStr : stringList) {
            int integer = InnerCharUtils.parseInt(numStr);
            if (integer >= 0 && integer <= 256) continue;
            return false;
        }
        return true;
    }
}

