/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.check;

import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.api.context.InnerSensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordTypeEnum;
import com.taotao.boot.sensitive.sensitiveword.support.check.AbstractConditionWordCheck;

public class WordCheckNum
extends AbstractConditionWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckNum();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckNum.class;
    }

    @Override
    protected String getType() {
        return WordTypeEnum.NUM.getCode();
    }

    @Override
    protected boolean isCharCondition(char mappingChar, int index, InnerSensitiveWordContext checkContext) {
        return Character.isDigit(mappingChar);
    }

    @Override
    protected boolean isStringCondition(int index, StringBuilder stringBuilder, InnerSensitiveWordContext checkContext) {
        int bufferLen = stringBuilder.length();
        return bufferLen >= checkContext.wordContext().sensitiveCheckNumLen();
    }
}

