/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.check;

import com.taotao.boot.sensitive.sensitiveword.api.ISensitiveWordCharIgnore;
import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.api.IWordContext;
import com.taotao.boot.sensitive.sensitiveword.api.IWordData;
import com.taotao.boot.sensitive.sensitiveword.api.context.InnerSensitiveWordContext;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordContainsTypeEnum;
import com.taotao.boot.sensitive.sensitiveword.constant.enums.WordTypeEnum;
import com.taotao.boot.sensitive.sensitiveword.support.check.AbstractWordCheck;
import com.taotao.boot.sensitive.sensitiveword.support.result.WordLengthResult;
import java.util.Map;

public class WordCheckWord
extends AbstractWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckWord();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckWord.class;
    }

    @Override
    protected WordLengthResult getActualLength(int beginIndex, InnerSensitiveWordContext innerContext) {
        String txt = innerContext.originalText();
        Map<Character, Character> formatCharMapping = innerContext.formatCharMapping();
        IWordContext context = innerContext.wordContext();
        IWordData wordData = context.wordData();
        IWordData wordDataAllow = context.wordDataAllow();
        ISensitiveWordCharIgnore wordCharIgnore = context.charIgnore();
        boolean failFast = context.wordFailFast();
        StringBuilder stringBuilder = new StringBuilder();
        char[] rawChars = txt.toCharArray();
        int tempLen = 0;
        int maxWhite = 0;
        int maxBlack = 0;
        int skipLen = 0;
        for (int i = beginIndex; i < rawChars.length; ++i) {
            if (wordCharIgnore.ignore(i, rawChars, innerContext) && tempLen != 0) {
                ++tempLen;
                ++skipLen;
                continue;
            }
            char mappingChar = formatCharMapping.get(Character.valueOf(rawChars[i])).charValue();
            stringBuilder.append(mappingChar);
            ++tempLen;
            WordContainsTypeEnum wordContainsTypeEnumAllow = wordDataAllow.contains(stringBuilder, innerContext);
            WordContainsTypeEnum wordContainsTypeEnumDeny = wordData.contains(stringBuilder, innerContext);
            if (WordContainsTypeEnum.CONTAINS_END.equals((Object)wordContainsTypeEnumAllow)) {
                maxWhite = tempLen;
                if (failFast) {
                    wordContainsTypeEnumAllow = WordContainsTypeEnum.NOT_FOUND;
                }
            }
            if (WordContainsTypeEnum.CONTAINS_END.equals((Object)wordContainsTypeEnumDeny)) {
                maxBlack = tempLen;
                if (failFast) {
                    wordContainsTypeEnumDeny = WordContainsTypeEnum.NOT_FOUND;
                }
            }
            if (WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnumAllow) && WordContainsTypeEnum.NOT_FOUND.equals((Object)wordContainsTypeEnumDeny)) break;
        }
        String string = stringBuilder.toString();
        String wordAllow = string.substring(0, Math.max(0, maxWhite - skipLen));
        String wordDeny = string.substring(0, Math.max(0, maxBlack - skipLen));
        return WordLengthResult.newInstance().wordAllowLen(maxWhite).wordDenyLen(maxBlack).wordAllow(wordAllow).wordDeny(wordDeny);
    }

    @Override
    protected String getType() {
        return WordTypeEnum.WORD.getCode();
    }
}

