/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.check;

import com.taotao.boot.common.support.pipeline.Pipeline;
import com.taotao.boot.common.utils.collection.ArrayUtils;
import com.taotao.boot.common.utils.collection.CollectionUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordCheck;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckEmail;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckIPV4;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckInit;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckNone;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckNum;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckUrl;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckUrlNoPrefix;
import com.taotao.boot.sensitive.sensitiveword.support.check.WordCheckWord;
import java.util.Collection;

public final class WordChecks {
    private WordChecks() {
    }

    public static IWordCheck chains(final IWordCheck ... sensitiveChecks) {
        if (ArrayUtils.isEmpty((Object[])sensitiveChecks)) {
            return WordChecks.none();
        }
        return new WordCheckInit(){

            @Override
            protected void init(Pipeline<IWordCheck> pipeline) {
                for (IWordCheck check : sensitiveChecks) {
                    pipeline.addLast((Object)check);
                }
            }
        };
    }

    public static IWordCheck chains(final Collection<IWordCheck> sensitiveChecks) {
        if (CollectionUtils.isEmpty(sensitiveChecks)) {
            return WordChecks.none();
        }
        return new WordCheckInit(){

            @Override
            protected void init(Pipeline<IWordCheck> pipeline) {
                for (IWordCheck check : sensitiveChecks) {
                    pipeline.addLast((Object)check);
                }
            }
        };
    }

    public static IWordCheck email() {
        return WordCheckEmail.getInstance();
    }

    public static IWordCheck num() {
        return WordCheckNum.getInstance();
    }

    public static IWordCheck url() {
        return WordCheckUrl.getInstance();
    }

    public static IWordCheck word() {
        return WordCheckWord.getInstance();
    }

    public static IWordCheck none() {
        return WordCheckNone.getInstance();
    }

    public static IWordCheck ipv4() {
        return WordCheckIPV4.getInstance();
    }

    public static IWordCheck urlNoPrefix() {
        return WordCheckUrlNoPrefix.getInstance();
    }
}

