/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.sensitive.sensitiveword.support.format;

import com.taotao.boot.common.support.pipeline.Pipeline;
import com.taotao.boot.common.utils.collection.ArrayUtils;
import com.taotao.boot.sensitive.sensitiveword.api.IWordFormat;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatIgnoreCase;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatIgnoreChineseStyle;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatIgnoreEnglishStyle;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatIgnoreNumStyle;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatIgnoreWidth;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatInit;
import com.taotao.boot.sensitive.sensitiveword.support.format.WordFormatNone;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.util.Collection;

public final class WordFormats {
    private WordFormats() {
    }

    public static IWordFormat chains(final IWordFormat ... charFormats) {
        if (ArrayUtils.isEmpty((Object[])charFormats)) {
            return WordFormats.none();
        }
        return new WordFormatInit(){

            @Override
            protected void init(Pipeline<IWordFormat> pipeline) {
                for (IWordFormat charFormat : charFormats) {
                    pipeline.addLast((Object)charFormat);
                }
            }
        };
    }

    public static IWordFormat chains(final Collection<IWordFormat> charFormats) {
        if (CollectionUtil.isEmpty(charFormats)) {
            return WordFormats.none();
        }
        return new WordFormatInit(){

            @Override
            protected void init(Pipeline<IWordFormat> pipeline) {
                for (IWordFormat charFormat : charFormats) {
                    pipeline.addLast((Object)charFormat);
                }
            }
        };
    }

    public static IWordFormat none() {
        return WordFormatNone.getInstance();
    }

    public static IWordFormat ignoreCase() {
        return WordFormatIgnoreCase.getInstance();
    }

    public static IWordFormat ignoreEnglishStyle() {
        return WordFormatIgnoreEnglishStyle.getInstance();
    }

    public static IWordFormat ignoreChineseStyle() {
        return WordFormatIgnoreChineseStyle.getInstance();
    }

    public static IWordFormat ignoreNumStyle() {
        return WordFormatIgnoreNumStyle.getInstance();
    }

    public static IWordFormat ignoreWidth() {
        return WordFormatIgnoreWidth.getInstance();
    }
}

